/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class PutninsP2Projection
extends Projection {
    private static final double C_x = 1.8949;
    private static final double C_y = 1.71848;
    private static final double C_p = 0.6141848493043784;
    private static final double EPS = 1.0E-10;
    private static final int NITER = 10;
    private static final double PI_DIV_3 = 1.0471975511965976;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        int i;
        double p = 0.6141848493043784 * Math.sin(lpphi);
        double s2 = lpphi * lpphi;
        out.y *= 0.615709 + s2 * (0.00909953 + s2 * 0.0046292);
        for (i = 10; i > 0; --i) {
            double c = Math.cos(lpphi);
            s2 = Math.sin(lpphi);
            double V = (lpphi + s2 * (c - 1.0) - p) / (1.0 + c * (c - 1.0) - s2 * s2);
            out.y -= V;
            if (Math.abs(V) < 1.0E-10) break;
        }
        if (i == 0) {
            out.y = lpphi < 0.0 ? -1.0471975511965976 : 1.0471975511965976;
        }
        out.x = 1.8949 * lplam * (Math.cos(lpphi) - 0.5);
        out.y = 1.71848 * Math.sin(lpphi);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = ProjectionMath.asin(xyy / 1.71848);
        double c = Math.cos(out.y);
        out.x = xyx / (1.8949 * (c - 0.5));
        out.y = ProjectionMath.asin((out.y + Math.sin(out.y) * (c - 1.0)) / 0.6141848493043784);
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Putnins P2";
    }
}

