/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.conversation;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.SearchHit;

public class Interaction
implements Writeable,
ToXContentObject {
    private String id;
    private Instant createTime;
    private String conversationId;
    private String input;
    private String promptTemplate;
    private String response;
    private String origin;
    private Map<String, String> additionalInfo;
    private String parentInteractionId;
    private Integer traceNum;

    public Interaction(String id, Instant createTime, String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo) {
        this.id = id;
        this.createTime = createTime;
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
        this.parentInteractionId = null;
        this.traceNum = null;
    }

    public static Interaction fromMap(String id, Map<String, Object> fields2) {
        Instant createTime = Instant.parse((String)fields2.get("create_time"));
        String conversationId = (String)fields2.get("memory_id");
        String input = (String)fields2.get("input");
        String promptTemplate = (String)fields2.get("prompt_template");
        String response = (String)fields2.get("response");
        String origin = (String)fields2.get("origin");
        Map additionalInfo = (Map)fields2.get("additional_info");
        String parentInteractionId = fields2.getOrDefault("parent_message_id", null);
        Integer traceNum = fields2.getOrDefault("trace_number", null);
        return new Interaction(id, createTime, conversationId, input, promptTemplate, response, origin, additionalInfo, parentInteractionId, traceNum);
    }

    public static Interaction fromSearchHit(SearchHit hit) {
        String id = hit.getId();
        return Interaction.fromMap(id, hit.getSourceAsMap());
    }

    public static Interaction fromStream(StreamInput in) throws IOException {
        String id = in.readString();
        Instant createTime = in.readInstant();
        String conversationId = in.readString();
        String input = in.readString();
        String promptTemplate = in.readString();
        String response = in.readString();
        String origin = in.readString();
        HashMap<String, String> additionalInfo = new HashMap();
        if (in.readBoolean()) {
            additionalInfo = in.readMap(s2 -> s2.readString(), s2 -> s2.readString());
        }
        String parentInteractionId = in.readOptionalString();
        Integer traceNum = in.readOptionalInt();
        return new Interaction(id, createTime, conversationId, input, promptTemplate, response, origin, additionalInfo, parentInteractionId, traceNum);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeInstant(this.createTime);
        out.writeString(this.conversationId);
        out.writeString(this.input);
        out.writeString(this.promptTemplate);
        out.writeString(this.response);
        out.writeString(this.origin);
        if (this.additionalInfo != null) {
            out.writeBoolean(true);
            out.writeMap(this.additionalInfo, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.parentInteractionId);
        out.writeOptionalInt(this.traceNum);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("memory_id", this.conversationId);
        builder.field("message_id", this.id);
        builder.field("create_time", (Object)this.createTime);
        if (this.input != null && !this.input.trim().isEmpty()) {
            builder.field("input", this.input);
        }
        if (this.promptTemplate != null && !this.promptTemplate.trim().isEmpty()) {
            builder.field("prompt_template", this.promptTemplate);
        }
        if (this.response != null && !this.response.trim().isEmpty()) {
            builder.field("response", this.response);
        }
        if (this.origin != null && !this.origin.trim().isEmpty()) {
            builder.field("origin", this.origin);
        }
        if (this.additionalInfo != null) {
            builder.field("additional_info", this.additionalInfo);
        }
        if (this.parentInteractionId != null) {
            builder.field("parent_message_id", this.parentInteractionId);
        }
        if (this.traceNum != null) {
            builder.field("trace_number", this.traceNum);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        return other instanceof Interaction && ((Interaction)other).id.equals(this.id) && ((Interaction)other).conversationId.equals(this.conversationId) && ((Interaction)other).createTime.equals(this.createTime) && ((Interaction)other).input.equals(this.input) && ((Interaction)other).promptTemplate.equals(this.promptTemplate) && ((Interaction)other).response.equals(this.response) && ((Interaction)other).origin.equals(this.origin) && (((Interaction)other).additionalInfo == null && this.additionalInfo == null || ((Interaction)other).additionalInfo.equals(this.additionalInfo)) && (((Interaction)other).parentInteractionId == null && this.parentInteractionId == null || ((Interaction)other).parentInteractionId.equals(this.parentInteractionId)) && (((Interaction)other).traceNum == null && this.traceNum == null || ((Interaction)other).traceNum.equals(this.traceNum));
    }

    public String toString() {
        return "Interaction{id=" + this.id + ",cid=" + this.conversationId + ",create_time=" + String.valueOf(this.createTime) + ",origin=" + this.origin + ",input=" + this.input + ",promt_template=" + this.promptTemplate + ",response=" + this.response + ",additional_info=" + String.valueOf(this.additionalInfo) + ",parentInteractionId=" + this.parentInteractionId + ",traceNum=" + this.traceNum + "}";
    }

    @Generated
    public static InteractionBuilder builder() {
        return new InteractionBuilder();
    }

    @Generated
    public InteractionBuilder toBuilder() {
        return new InteractionBuilder().id(this.id).createTime(this.createTime).conversationId(this.conversationId).input(this.input).promptTemplate(this.promptTemplate).response(this.response).origin(this.origin).additionalInfo(this.additionalInfo);
    }

    @Generated
    public Interaction(String id, Instant createTime, String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, String parentInteractionId, Integer traceNum) {
        this.id = id;
        this.createTime = createTime;
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
        this.parentInteractionId = parentInteractionId;
        this.traceNum = traceNum;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public String getParentInteractionId() {
        return this.parentInteractionId;
    }

    @Generated
    public Integer getTraceNum() {
        return this.traceNum;
    }

    @Generated
    public static class InteractionBuilder {
        @Generated
        private String id;
        @Generated
        private Instant createTime;
        @Generated
        private String conversationId;
        @Generated
        private String input;
        @Generated
        private String promptTemplate;
        @Generated
        private String response;
        @Generated
        private String origin;
        @Generated
        private Map<String, String> additionalInfo;
        @Generated
        private String parentInteractionId;
        @Generated
        private Integer traceNum;

        @Generated
        InteractionBuilder() {
        }

        @Generated
        public InteractionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public InteractionBuilder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Generated
        public InteractionBuilder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        @Generated
        public InteractionBuilder input(String input) {
            this.input = input;
            return this;
        }

        @Generated
        public InteractionBuilder promptTemplate(String promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        @Generated
        public InteractionBuilder response(String response) {
            this.response = response;
            return this;
        }

        @Generated
        public InteractionBuilder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public InteractionBuilder additionalInfo(Map<String, String> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Generated
        public InteractionBuilder parentInteractionId(String parentInteractionId) {
            this.parentInteractionId = parentInteractionId;
            return this;
        }

        @Generated
        public InteractionBuilder traceNum(Integer traceNum) {
            this.traceNum = traceNum;
            return this;
        }

        @Generated
        public Interaction build() {
            return new Interaction(this.id, this.createTime, this.conversationId, this.input, this.promptTemplate, this.response, this.origin, this.additionalInfo, this.parentInteractionId, this.traceNum);
        }

        @Generated
        public String toString() {
            return "Interaction.InteractionBuilder(id=" + this.id + ", createTime=" + String.valueOf(this.createTime) + ", conversationId=" + this.conversationId + ", input=" + this.input + ", promptTemplate=" + this.promptTemplate + ", response=" + this.response + ", origin=" + this.origin + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ", parentInteractionId=" + this.parentInteractionId + ", traceNum=" + this.traceNum + ")";
        }
    }
}

