/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.ExpressionAnalyzer;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.NestedAllTupleFields;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.planner.logical.LogicalNested;
import org.opensearch.sql.planner.logical.LogicalPlan;

public class NestedAnalyzer
extends AbstractNodeVisitor<LogicalPlan, AnalysisContext> {
    private final List<NamedExpression> namedExpressions;
    private final ExpressionAnalyzer expressionAnalyzer;
    private final LogicalPlan child;

    public LogicalPlan analyze(UnresolvedExpression projectItem, AnalysisContext context) {
        LogicalPlan nested = projectItem.accept(this, context);
        return nested == null ? this.child : nested;
    }

    @Override
    public LogicalPlan visitAlias(Alias node, AnalysisContext context) {
        return node.getDelegated().accept(this, context);
    }

    @Override
    public LogicalPlan visitNestedAllTupleFields(NestedAllTupleFields node, AnalysisContext context) {
        ArrayList<Map<String, ReferenceExpression>> args2 = new ArrayList<Map<String, ReferenceExpression>>();
        for (NamedExpression namedExpr : this.namedExpressions) {
            ReferenceExpression field;
            if (!NestedAnalyzer.isNestedFunction(namedExpr.getDelegated()).booleanValue() || !(field = (ReferenceExpression)((FunctionExpression)namedExpr.getDelegated()).getArguments().get(0)).getAttr().substring(0, field.getAttr().lastIndexOf(".")).equalsIgnoreCase(node.getPath())) continue;
            args2.add(Map.of("field", field, "path", new ReferenceExpression(node.getPath(), ExprCoreType.STRING)));
        }
        return this.mergeChildIfLogicalNested(args2);
    }

    @Override
    public LogicalPlan visitFunction(Function node, AnalysisContext context) {
        if (node.getFuncName().equalsIgnoreCase(BuiltinFunctionName.NESTED.name())) {
            List<UnresolvedExpression> expressions = node.getFuncArgs();
            this.validateArgs(expressions);
            ReferenceExpression nestedField = (ReferenceExpression)this.expressionAnalyzer.analyze(expressions.get(0), context);
            Map<String, ReferenceExpression> args2 = expressions.size() == 2 ? Map.of("field", nestedField, "path", (ReferenceExpression)this.expressionAnalyzer.analyze(expressions.get(1), context)) : Map.of("field", (ReferenceExpression)this.expressionAnalyzer.analyze(expressions.get(0), context), "path", NestedAnalyzer.generatePath(nestedField.toString()));
            return this.mergeChildIfLogicalNested(new ArrayList<Map<String, ReferenceExpression>>(Arrays.asList(args2)));
        }
        return null;
    }

    private LogicalPlan mergeChildIfLogicalNested(List<Map<String, ReferenceExpression>> args2) {
        if (this.child instanceof LogicalNested) {
            for (Map<String, ReferenceExpression> arg : args2) {
                ((LogicalNested)this.child).addFields(arg);
            }
            return this.child;
        }
        return new LogicalNested(this.child, args2, this.namedExpressions);
    }

    private void validateArgs(List<UnresolvedExpression> args2) {
        if (args2.size() < 1 || args2.size() > 2) {
            throw new IllegalArgumentException("on nested object only allowed 2 parameters (field,path) or 1 parameter (field)");
        }
        for (int i = 0; i < args2.size(); ++i) {
            if (!(args2.get(i) instanceof QualifiedName)) {
                throw new IllegalArgumentException(String.format("Illegal nested field name: %s", args2.get(i).toString()));
            }
            if (i != 0 || ((QualifiedName)args2.get(i)).getParts().size() >= 2) continue;
            throw new IllegalArgumentException(String.format("Illegal nested field name: %s", args2.get(i).toString()));
        }
    }

    public static ReferenceExpression generatePath(String field) {
        return new ReferenceExpression(field.substring(0, field.lastIndexOf(".")), ExprCoreType.STRING);
    }

    public static Boolean isNestedFunction(Expression expr) {
        return expr instanceof FunctionExpression && ((FunctionExpression)expr).getFunctionName().getFunctionName().equalsIgnoreCase(BuiltinFunctionName.NESTED.name());
    }

    @Generated
    public NestedAnalyzer(List<NamedExpression> namedExpressions, ExpressionAnalyzer expressionAnalyzer, LogicalPlan child) {
        this.namedExpressions = namedExpressions;
        this.expressionAnalyzer = expressionAnalyzer;
        this.child = child;
    }
}

