/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import shaded.com.google.common.collect.ImmutableList;

public class Relation
extends UnresolvedPlan {
    private static final String COMMA = ",";
    private final List<UnresolvedExpression> tableNames;

    public Relation(UnresolvedExpression tableName) {
        this.tableNames = Collections.singletonList(tableName);
    }

    public List<QualifiedName> getQualifiedNames() {
        return this.tableNames.stream().map(t2 -> (QualifiedName)t2).collect(Collectors.toList());
    }

    public QualifiedName getTableQualifiedName() {
        if (this.tableNames.size() == 1) {
            return (QualifiedName)this.tableNames.get(0);
        }
        return new QualifiedName(this.tableNames.stream().map(UnresolvedExpression::toString).collect(Collectors.joining(COMMA)));
    }

    public List<UnresolvedPlan> getChild() {
        return ImmutableList.of();
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitRelation(this, context);
    }

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "Relation(tableNames=" + String.valueOf(this.getTableNames()) + ")";
    }

    @Generated
    public List<UnresolvedExpression> getTableNames() {
        return this.tableNames;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation other = (Relation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedExpression> this$tableNames = this.getTableNames();
        List<UnresolvedExpression> other$tableNames = other.getTableNames();
        return !(this$tableNames == null ? other$tableNames != null : !((Object)this$tableNames).equals(other$tableNames));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Relation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        List<UnresolvedExpression> $tableNames = this.getTableNames();
        result2 = result2 * 59 + ($tableNames == null ? 43 : ((Object)$tableNames).hashCode());
        return result2;
    }

    @Generated
    public Relation(List<UnresolvedExpression> tableNames) {
        this.tableNames = tableNames;
    }
}

