/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.opensearch.sql.DataSourceSchemaName;
import org.opensearch.sql.analysis.DataSourceSchemaIdentifierNameResolver;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.datasource.DataSourceService;

public class OpenSearchSchema
extends AbstractSchema {
    public static final String OPEN_SEARCH_SCHEMA_NAME = "OpenSearch";
    private final DataSourceService dataSourceService;
    private final Map<String, Table> tableMap = new HashMap<String, Table>(){

        @Override
        public Table get(Object key) {
            if (!super.containsKey(key)) {
                OpenSearchSchema.this.registerTable(new QualifiedName((String)key));
            }
            return (Table)super.get(key);
        }
    };

    public void registerTable(QualifiedName qualifiedName2) {
        DataSourceSchemaIdentifierNameResolver nameResolver = new DataSourceSchemaIdentifierNameResolver(this.dataSourceService, qualifiedName2.getParts());
        org.opensearch.sql.storage.Table table = this.dataSourceService.getDataSource(nameResolver.getDataSourceName()).getStorageEngine().getTable(new DataSourceSchemaName(nameResolver.getDataSourceName(), nameResolver.getSchemaName()), nameResolver.getIdentifierName());
        this.tableMap.put(qualifiedName2.toString(), (Table)((Object)table));
    }

    @Generated
    public DataSourceService getDataSourceService() {
        return this.dataSourceService;
    }

    @Override
    @Generated
    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    @Generated
    public OpenSearchSchema(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }
}

