/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.type;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.locationtech.jts.geom.Geometry;
import org.opensearch.sql.calcite.type.AbstractExprRelDataType;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;

public class ExprSqlType
extends AbstractExprRelDataType<BasicSqlType> {
    public ExprSqlType(OpenSearchTypeFactory typeFactory, OpenSearchTypeFactory.ExprUDT exprUDT, SqlTypeName sqlTypeName) {
        this(exprUDT, (BasicSqlType)typeFactory.createSqlType(sqlTypeName));
    }

    protected ExprSqlType(OpenSearchTypeFactory.ExprUDT exprUDT, BasicSqlType type2) {
        super(exprUDT, type2);
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append(this.udt.name());
        sb.append(' ');
        try {
            Method method = BasicSqlType.class.getDeclaredMethod("generateTypeString", StringBuilder.class, Boolean.TYPE);
            method.setAccessible(true);
            method.invoke(this.relType, sb, withDetail);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke generateTypeString for BasicSqlType", e);
        }
    }

    @Override
    public Type getJavaType() {
        SqlTypeName type2 = ((BasicSqlType)this.relType).getSqlTypeName();
        return switch (type2) {
            case SqlTypeName.VARCHAR, SqlTypeName.CHAR -> String.class;
            case SqlTypeName.DATE, SqlTypeName.TIME, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIME_TZ, SqlTypeName.INTEGER, SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_YEAR_MONTH, SqlTypeName.INTERVAL_MONTH -> {
                if (this.isNullable()) {
                    yield Integer.class;
                }
                yield Integer.TYPE;
            }
            case SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIMESTAMP_TZ, SqlTypeName.BIGINT, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeName.INTERVAL_SECOND -> {
                if (this.isNullable()) {
                    yield Long.class;
                }
                yield Long.TYPE;
            }
            case SqlTypeName.SMALLINT -> {
                if (this.isNullable()) {
                    yield Short.class;
                }
                yield Short.TYPE;
            }
            case SqlTypeName.TINYINT -> {
                if (this.isNullable()) {
                    yield Byte.class;
                }
                yield Byte.TYPE;
            }
            case SqlTypeName.DECIMAL -> BigDecimal.class;
            case SqlTypeName.BOOLEAN -> {
                if (this.isNullable()) {
                    yield Boolean.class;
                }
                yield Boolean.TYPE;
            }
            case SqlTypeName.DOUBLE, SqlTypeName.FLOAT -> {
                if (this.isNullable()) {
                    yield Double.class;
                }
                yield Double.TYPE;
            }
            case SqlTypeName.REAL -> {
                if (this.isNullable()) {
                    yield Float.class;
                }
                yield Float.TYPE;
            }
            case SqlTypeName.BINARY, SqlTypeName.VARBINARY -> ByteString.class;
            case SqlTypeName.GEOMETRY -> Geometry.class;
            case SqlTypeName.SYMBOL -> Enum.class;
            case SqlTypeName.ANY -> Object.class;
            case SqlTypeName.NULL -> Void.class;
            default -> throw new IllegalArgumentException("Unsupported sql type name: " + String.valueOf((Object)type2));
        };
    }

    @Override
    public ExprSqlType createWithNullability(OpenSearchTypeFactory typeFactory, boolean nullable) {
        if (this.isNullable() == nullable) {
            return this;
        }
        return new ExprSqlType(this.udt, (BasicSqlType)typeFactory.createTypeWithNullability((RelDataType)this.relType, nullable));
    }

    @Override
    public ExprSqlType createWithCharsetAndCollation(OpenSearchTypeFactory typeFactory, Charset charset, SqlCollation collation) {
        return new ExprSqlType(this.udt, (BasicSqlType)typeFactory.createTypeWithCharsetAndCollation((RelDataType)this.relType, charset, collation));
    }
}

