/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeConversionUtils;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.function.udf.datetime.AddSubDateFunction;

public class DateAddSubFunction
extends ImplementorUDF {
    public DateAddSubFunction(boolean isAdd) {
        super(new DateAddSubImplementor(isAdd), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.TIMESTAMP_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)((Object)OperandTypes.DATETIME_INTERVAL.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.DATETIME_INTERVAL))));
    }

    public static class DateAddSubImplementor
    implements NotNullImplementor {
        private final boolean isAdd;

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression temporal = translatedOperands.get(0);
            Expression temporalDelta = translatedOperands.get(1);
            RelDataType temporalType = call.getOperands().get(0).getType();
            RelDataType temporalDeltaType = call.getOperands().get(1).getType();
            MethodCallExpression interval = Expressions.call(DateTimeConversionUtils.class, "convertToTemporalAmount", new Expression[]{Expressions.convert_(temporalDelta, Long.TYPE), Expressions.constant((Object)Objects.requireNonNull(temporalDeltaType.getIntervalQualifier()).getUnit())});
            MethodCallExpression base = Expressions.call(ExprValueUtils.class, "fromObjectValue", new Expression[]{temporal, Expressions.constant(OpenSearchTypeFactory.convertRelDataTypeToExprType(temporalType))});
            MethodCallExpression properties2 = Expressions.call(UserDefinedFunctionUtils.class, "restoreFunctionProperties", new Expression[]{translator.getRoot()});
            String funcName = this.isAdd ? "dateAddInterval" : "dateSubInterval";
            return Expressions.call(AddSubDateFunction.AddSubDateImplementor.class, funcName, new Expression[]{properties2, base, interval});
        }

        @Generated
        public DateAddSubImplementor(boolean isAdd) {
            this.isAdd = isAdd;
        }
    }
}

