/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.ip;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.ip.IPFunctions;

public class CidrMatchFunction
extends ImplementorUDF {
    public CidrMatchFunction() {
        super(new CidrMatchImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.BOOLEAN_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap(OperandTypes.STRING_STRING);
    }

    public static class CidrMatchImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(CidrMatchImplementor.class, "cidrMatch", translatedOperands);
        }

        public static boolean cidrMatch(ExprIpValue ip, String cidr) {
            ExprValue cidrValue = ExprValueUtils.stringValue(cidr);
            return (Boolean)IPFunctions.exprCidrMatch(ip, cidrValue).valueForCalcite();
        }

        public static boolean cidrMatch(String ip, String cidr) {
            ExprIpValue ipValue = (ExprIpValue)ExprValueUtils.ipValue(ip);
            return CidrMatchImplementor.cidrMatch(ipValue, cidr);
        }
    }
}

