/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.KVValue;
import org.opensearch.sql.legacy.parser.NestedType;
import org.opensearch.sql.legacy.utils.Util;

public class MethodField
extends Field {
    private List<KVValue> params = null;

    public MethodField(String name, List<KVValue> params, SQLAggregateOption option, String alias) {
        super(name, alias);
        this.params = params;
        this.option = option;
        if (alias == null || alias.trim().length() == 0) {
            Map<String, Object> paramsAsMap = this.getParamsAsMap();
            if (paramsAsMap.containsKey("alias")) {
                this.setAlias(paramsAsMap.get("alias").toString());
            } else {
                this.setAlias(this.toString());
            }
        }
    }

    public List<KVValue> getParams() {
        return this.params;
    }

    public Map<String, Object> getParamsAsMap() {
        HashMap<String, Object> paramsAsMap = new HashMap<String, Object>();
        if (this.params == null) {
            return paramsAsMap;
        }
        for (KVValue kvValue : this.params) {
            paramsAsMap.put(kvValue.key, kvValue.value);
        }
        return paramsAsMap;
    }

    @Override
    public String toString() {
        if (this.option != null) {
            return this.name + "(" + String.valueOf((Object)this.option) + " " + Util.joiner(this.params, ",") + ")";
        }
        return this.name + "(" + Util.joiner(this.params, ",") + ")";
    }

    @Override
    public boolean isNested() {
        Map<String, Object> paramsAsMap = this.getParamsAsMap();
        return paramsAsMap.containsKey("nested") || paramsAsMap.containsKey("reverse_nested");
    }

    @Override
    public boolean isReverseNested() {
        return this.getParamsAsMap().containsKey("reverse_nested");
    }

    @Override
    public String getNestedPath() {
        if (!this.isNested()) {
            return null;
        }
        if (this.isReverseNested()) {
            String reverseNestedPath = this.getParamsAsMap().get("reverse_nested").toString();
            return reverseNestedPath.isEmpty() ? null : reverseNestedPath;
        }
        Object nestedField = this.getParamsAsMap().get("nested");
        if (nestedField instanceof NestedType) {
            return ((NestedType)nestedField).path;
        }
        return nestedField.toString();
    }

    @Override
    public boolean isChildren() {
        Map<String, Object> paramsAsMap = this.getParamsAsMap();
        return paramsAsMap.containsKey("children");
    }

    @Override
    public String getChildType() {
        if (!this.isChildren()) {
            return null;
        }
        return this.getParamsAsMap().get("children").toString();
    }

    @Override
    public boolean isScriptField() {
        return "script".equals(this.getName());
    }
}

