/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.maker;

import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.json.JsonXContentParser;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoHashGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.join.aggregations.ChildrenAggregationBuilder;
import org.opensearch.join.aggregations.JoinAggregationBuilders;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.opensearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.opensearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ExtendedStatsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ScriptedMetricAggregationBuilder;
import org.opensearch.search.aggregations.metrics.StatsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.domain.KVValue;
import org.opensearch.sql.legacy.domain.MethodField;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.domain.bucketpath.Path;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.parser.ChildrenType;
import org.opensearch.sql.legacy.parser.NestedType;
import org.opensearch.sql.legacy.query.maker.QueryMaker;
import org.opensearch.sql.legacy.utils.Util;

public class AggMaker {
    private final Map<String, KVValue> groupMap = new HashMap<String, KVValue>();
    private Where where;
    private static final String TIME_FARMAT = "yyyy-MM-dd HH:mm:ss";

    public AggregationBuilder makeGroupAgg(Field field) throws SqlParseException {
        if (field instanceof MethodField && field.getName().equals("script")) {
            MethodField methodField = (MethodField)field;
            TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)methodField.getAlias()).script(new Script(methodField.getParams().get((int)1).value.toString()));
            this.extendGroupMap(methodField, new KVValue("KEY", termsBuilder));
            return termsBuilder;
        }
        if (field instanceof MethodField) {
            MethodField methodField = (MethodField)field;
            if (methodField.getName().equals("filter")) {
                Map<String, Object> paramsAsMap = methodField.getParamsAsMap();
                Where where = (Where)paramsAsMap.get("where");
                return AggregationBuilders.filter((String)paramsAsMap.get("alias").toString(), (QueryBuilder)QueryMaker.explain(where));
            }
            return this.makeRangeGroup(methodField);
        }
        String termName = Strings.isNullOrEmpty((String)field.getAlias()) ? field.getName() : field.getAlias();
        TermsAggregationBuilder termsBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)termName).field(field.getName());
        KVValue kvValue = new KVValue("KEY", termsBuilder);
        this.groupMap.put(termName, kvValue);
        this.groupMap.putIfAbsent(field.getName(), kvValue);
        return termsBuilder;
    }

    public AggregationBuilder makeFieldAgg(MethodField field, AggregationBuilder parent) throws SqlParseException {
        this.extendGroupMap(field, new KVValue("FIELD", parent));
        field.setAlias(this.fixAlias(field.getAlias()));
        switch (field.getName().toUpperCase()) {
            case "SUM": {
                SumAggregationBuilder builder = AggregationBuilders.sum((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "MAX": {
                MaxAggregationBuilder builder = AggregationBuilders.max((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "MIN": {
                MinAggregationBuilder builder = AggregationBuilders.min((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "AVG": {
                AvgAggregationBuilder builder = AggregationBuilders.avg((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "STATS": {
                StatsAggregationBuilder builder = AggregationBuilders.stats((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "EXTENDED_STATS": {
                ExtendedStatsAggregationBuilder builder = AggregationBuilders.extendedStats((String)field.getAlias());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "PERCENTILES": {
                PercentilesAggregationBuilder builder = AggregationBuilders.percentiles((String)field.getAlias());
                this.addSpecificPercentiles(builder, field.getParams());
                return this.addFieldToAgg(field, (ValuesSourceAggregationBuilder)builder);
            }
            case "TOPHITS": {
                return this.makeTopHitsAgg(field);
            }
            case "SCRIPTED_METRIC": {
                return this.scriptedMetric(field);
            }
            case "COUNT": {
                this.extendGroupMap(field, new KVValue("COUNT", parent));
                return this.addFieldToAgg(field, this.makeCountAgg(field));
            }
        }
        throw new SqlParseException("the agg function not to define !");
    }

    public AggMaker withWhere(Where where) {
        this.where = where;
        return this;
    }

    private void addSpecificPercentiles(PercentilesAggregationBuilder percentilesBuilder, List<KVValue> params) {
        ArrayList<Double> percentiles = new ArrayList<Double>();
        for (KVValue kValue : params) {
            if (kValue.value.getClass().equals(BigDecimal.class)) {
                BigDecimal percentile = (BigDecimal)kValue.value;
                percentiles.add(percentile.doubleValue());
                continue;
            }
            if (!(kValue.value instanceof Integer)) continue;
            percentiles.add(((Integer)kValue.value).doubleValue());
        }
        if (percentiles.size() > 0) {
            double[] percentilesArr = new double[percentiles.size()];
            int i = 0;
            for (Double percentile : percentiles) {
                percentilesArr[i] = percentile;
                ++i;
            }
            percentilesBuilder.percentiles(percentilesArr);
        }
    }

    private String fixAlias(String alias) {
        return alias.replaceAll("\\[", "(").replaceAll("\\]", ")");
    }

    private AggregationBuilder addFieldToAgg(MethodField field, ValuesSourceAggregationBuilder builder) throws SqlParseException {
        KVValue kvValue = field.getParams().get(0);
        if (kvValue.key != null && kvValue.key.equals("script")) {
            if (kvValue.value instanceof MethodField) {
                return builder.script(new Script(((MethodField)kvValue.value).getParams().get(1).toString()));
            }
            return builder.script(new Script(kvValue.value.toString()));
        }
        if (kvValue.key != null && kvValue.value.toString().trim().startsWith("def")) {
            return builder.script(new Script(kvValue.value.toString()));
        }
        if (kvValue.key != null && (kvValue.key.equals("nested") || kvValue.key.equals("reverse_nested"))) {
            NestedAggregationBuilder nestedBuilder;
            NestedType nestedType = (NestedType)kvValue.value;
            nestedType.addBucketPath(Path.getMetricPath(builder.getName()));
            if (nestedType.isNestedField()) {
                builder.field("_index");
            } else {
                builder.field(nestedType.field);
            }
            String nestedAggName = nestedType.getNestedAggName();
            if (nestedType.isReverse()) {
                if (nestedType.path != null && nestedType.path.startsWith("~")) {
                    String realPath = nestedType.path.substring(1);
                    NestedAggregationBuilder nestedBuilder2 = AggregationBuilders.nested((String)nestedAggName, (String)realPath);
                    nestedBuilder2 = nestedBuilder2.subAggregation((AggregationBuilder)builder);
                    return AggregationBuilders.reverseNested((String)(nestedAggName + "_REVERSED")).subAggregation((AggregationBuilder)nestedBuilder2);
                }
                ReverseNestedAggregationBuilder reverseNestedAggregationBuilder = AggregationBuilders.reverseNested((String)nestedAggName);
                if (nestedType.path != null) {
                    reverseNestedAggregationBuilder.path(nestedType.path);
                }
                nestedBuilder = reverseNestedAggregationBuilder;
            } else {
                nestedBuilder = AggregationBuilders.nested((String)nestedAggName, (String)nestedType.path);
            }
            AggregationBuilder aggregation = nestedBuilder.subAggregation(this.wrapWithFilterAgg(nestedType, builder));
            nestedType.addBucketPath(Path.getAggPath(nestedBuilder.getName()));
            return aggregation;
        }
        if (kvValue.key != null && kvValue.key.equals("children")) {
            ChildrenType childrenType = (ChildrenType)kvValue.value;
            builder.field(childrenType.field);
            String childrenAggName = childrenType.field + "@CHILDREN";
            ChildrenAggregationBuilder childrenBuilder = JoinAggregationBuilders.children(childrenAggName, childrenType.childType);
            return childrenBuilder;
        }
        return builder.field(kvValue.toString());
    }

    private AggregationBuilder makeRangeGroup(MethodField field) throws SqlParseException {
        switch (field.getName().toLowerCase()) {
            case "range": {
                return this.rangeBuilder(field);
            }
            case "date_histogram": {
                return this.dateHistogram(field);
            }
            case "date_range": 
            case "month": {
                return this.dateRange(field);
            }
            case "histogram": {
                return this.histogram(field);
            }
            case "geohash_grid": {
                return this.geohashGrid(field);
            }
            case "geo_bounds": {
                return this.geoBounds(field);
            }
            case "terms": {
                return this.termsAgg(field);
            }
        }
        throw new SqlParseException("can define this method " + String.valueOf(field));
    }

    private AggregationBuilder geoBounds(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        GeoBoundsAggregationBuilder boundsBuilder = new GeoBoundsAggregationBuilder(aggName);
        block13: for (KVValue kv : field.getParams()) {
            String value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "field": {
                    boundsBuilder.field(value);
                    continue block13;
                }
                case "wrap_longitude": {
                    boundsBuilder.wrapLongitude(Boolean.getBoolean(value));
                    continue block13;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block13;
                }
            }
            throw new SqlParseException("geo_bounds err or not define field " + kv.toString());
        }
        return boundsBuilder;
    }

    private AggregationBuilder termsAgg(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        TermsAggregationBuilder terms = AggregationBuilders.terms((String)aggName);
        IncludeExclude include = null;
        IncludeExclude exclude = null;
        block48: for (KVValue kv : field.getParams()) {
            if (kv.value.toString().contains("doc[")) {
                String script = String.valueOf(kv.value) + "; return " + kv.key;
                terms.script(new Script(script));
                continue;
            }
            String value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "field": {
                    terms.field(value);
                    break;
                }
                case "size": {
                    terms.size(Integer.parseInt(value));
                    break;
                }
                case "shard_size": {
                    terms.shardSize(Integer.parseInt(value));
                    break;
                }
                case "min_doc_count": {
                    terms.minDocCount((long)Integer.parseInt(value));
                    break;
                }
                case "missing": {
                    terms.missing((Object)value);
                    break;
                }
                case "order": {
                    if ("asc".equalsIgnoreCase(value)) {
                        terms.order(BucketOrder.key((boolean)true));
                        break;
                    }
                    if ("desc".equalsIgnoreCase(value)) {
                        terms.order(BucketOrder.key((boolean)false));
                        break;
                    }
                    ArrayList<BucketOrder> orderElements = new ArrayList<BucketOrder>();
                    try (JsonXContentParser parser = new JsonXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, new JsonFactory().createParser(value));){
                        XContentParser.Token currentToken = parser.nextToken();
                        if (currentToken == XContentParser.Token.START_OBJECT) {
                            orderElements.add(InternalOrder.Parser.parseOrderParam((XContentParser)parser));
                        } else if (currentToken == XContentParser.Token.START_ARRAY) {
                            currentToken = parser.nextToken();
                            while (currentToken != XContentParser.Token.END_ARRAY) {
                                if (currentToken != XContentParser.Token.START_OBJECT) {
                                    throw new ParsingException(parser.getTokenLocation(), "Invalid token in order array", new Object[0]);
                                }
                                orderElements.add(InternalOrder.Parser.parseOrderParam((XContentParser)parser));
                                currentToken = parser.nextToken();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("couldn't parse order: " + e.getMessage());
                    }
                    terms.order(orderElements);
                    break;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    break;
                }
                case "execution_hint": {
                    terms.executionHint(value);
                    break;
                }
                case "include": {
                    XContentParser parser;
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        try {
                            parser.nextToken();
                            include = IncludeExclude.parseInclude((XContentParser)parser);
                            continue block48;
                        }
                        finally {
                            if (parser == null) continue block48;
                            parser.close();
                            continue block48;
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("parse include[" + value + "] error: " + e.getMessage());
                    }
                }
                case "exclude": {
                    XContentParser parser;
                    try {
                        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);
                        try {
                            parser.nextToken();
                            exclude = IncludeExclude.parseExclude((XContentParser)parser);
                            continue block48;
                        }
                        finally {
                            if (parser == null) continue block48;
                            parser.close();
                            continue block48;
                        }
                    }
                    catch (IOException e) {
                        throw new SqlParseException("parse exclude[" + value + "] error: " + e.getMessage());
                    }
                }
                default: {
                    throw new SqlParseException("terms aggregation err or not define field " + kv.toString());
                }
            }
        }
        terms.includeExclude(IncludeExclude.merge(include, exclude));
        return terms;
    }

    private AbstractAggregationBuilder scriptedMetric(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        ScriptedMetricAggregationBuilder scriptedMetricBuilder = AggregationBuilders.scriptedMetric((String)aggName);
        Map<String, Object> scriptedMetricParams = field.getParamsAsMap();
        if (!(scriptedMetricParams.containsKey("map_script") || scriptedMetricParams.containsKey("map_script_id") || scriptedMetricParams.containsKey("map_script_file"))) {
            throw new SqlParseException("scripted metric parameters must contain map_script/map_script_id/map_script_file parameter");
        }
        HashMap<String, Object> scriptAdditionalParams = new HashMap<String, Object>();
        HashMap<String, Object> reduceScriptAdditionalParams = new HashMap<String, Object>();
        block25: for (Map.Entry<String, Object> param : scriptedMetricParams.entrySet()) {
            String paramValue = param.getValue().toString();
            if (param.getKey().startsWith("@")) {
                if (param.getKey().startsWith("@reduce_")) {
                    reduceScriptAdditionalParams.put(param.getKey().replace("@reduce_", ""), param.getValue());
                    continue;
                }
                scriptAdditionalParams.put(param.getKey().replace("@", ""), param.getValue());
                continue;
            }
            switch (param.getKey().toLowerCase()) {
                case "map_script": {
                    scriptedMetricBuilder.mapScript(new Script(paramValue));
                    continue block25;
                }
                case "map_script_id": {
                    scriptedMetricBuilder.mapScript(new Script(ScriptType.STORED, "painless", paramValue, new HashMap()));
                    continue block25;
                }
                case "init_script": {
                    scriptedMetricBuilder.initScript(new Script(paramValue));
                    continue block25;
                }
                case "init_script_id": {
                    scriptedMetricBuilder.initScript(new Script(ScriptType.STORED, "painless", paramValue, new HashMap()));
                    continue block25;
                }
                case "combine_script": {
                    scriptedMetricBuilder.combineScript(new Script(paramValue));
                    continue block25;
                }
                case "combine_script_id": {
                    scriptedMetricBuilder.combineScript(new Script(ScriptType.STORED, "painless", paramValue, new HashMap()));
                    continue block25;
                }
                case "reduce_script": {
                    scriptedMetricBuilder.reduceScript(new Script(ScriptType.INLINE, "painless", paramValue, reduceScriptAdditionalParams));
                    continue block25;
                }
                case "reduce_script_id": {
                    scriptedMetricBuilder.reduceScript(new Script(ScriptType.STORED, "painless", paramValue, reduceScriptAdditionalParams));
                    continue block25;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block25;
                }
            }
            throw new SqlParseException("scripted_metric err or not define field " + param.getKey());
        }
        if (scriptAdditionalParams.size() > 0) {
            scriptAdditionalParams.put("_agg", new HashMap());
            scriptedMetricBuilder.params(scriptAdditionalParams);
        }
        return scriptedMetricBuilder;
    }

    private AggregationBuilder geohashGrid(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        GeoHashGridAggregationBuilder geoHashGrid = new GeoHashGridAggregationBuilder(aggName);
        block17: for (KVValue kv : field.getParams()) {
            String value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "precision": {
                    ((GeoGridAggregationBuilder)geoHashGrid).precision(Integer.parseInt(value));
                    continue block17;
                }
                case "field": {
                    geoHashGrid.field(value);
                    continue block17;
                }
                case "size": {
                    geoHashGrid.size(Integer.parseInt(value));
                    continue block17;
                }
                case "shard_size": {
                    geoHashGrid.shardSize(Integer.parseInt(value));
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            throw new SqlParseException("geohash grid err or not define field " + kv.toString());
        }
        return geoHashGrid;
    }

    private ValuesSourceAggregationBuilder dateRange(MethodField field) {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        DateRangeAggregationBuilder dateRange = (DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)alias).format(TIME_FARMAT);
        ArrayList<String> ranges = new ArrayList<String>();
        for (KVValue kv : field.getParams()) {
            String value = kv.value.toString();
            if ("field".equals(kv.key)) {
                dateRange.field(value);
                continue;
            }
            if ("format".equals(kv.key)) {
                dateRange.format(value);
                continue;
            }
            if ("time_zone".equals(kv.key)) {
                dateRange.timeZone((ZoneId)ZoneOffset.of(value));
                continue;
            }
            if ("from".equals(kv.key)) {
                dateRange.addUnboundedFrom(kv.value.toString());
                continue;
            }
            if ("to".equals(kv.key)) {
                dateRange.addUnboundedTo(kv.value.toString());
                continue;
            }
            if ("alias".equals(kv.key) || "nested".equals(kv.key) || "children".equals(kv.key)) continue;
            ranges.add(value);
        }
        for (int i = 1; i < ranges.size(); ++i) {
            dateRange.addRange((String)ranges.get(i - 1), (String)ranges.get(i));
        }
        return dateRange;
    }

    private DateHistogramAggregationBuilder dateHistogram(MethodField field) throws SqlParseException {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        DateHistogramAggregationBuilder dateHistogram = (DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)alias).format(TIME_FARMAT);
        block25: for (KVValue kv : field.getParams()) {
            if (kv.value.toString().contains("doc[")) {
                String script = String.valueOf(kv.value) + "; return " + kv.key;
                dateHistogram.script(new Script(script));
                continue;
            }
            String value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "interval": {
                    dateHistogram.dateHistogramInterval(new DateHistogramInterval(kv.value.toString()));
                    continue block25;
                }
                case "fixed_interval": {
                    dateHistogram.fixedInterval(new DateHistogramInterval(kv.value.toString()));
                    continue block25;
                }
                case "field": {
                    dateHistogram.field(value);
                    continue block25;
                }
                case "format": {
                    dateHistogram.format(value);
                    continue block25;
                }
                case "time_zone": {
                    dateHistogram.timeZone((ZoneId)ZoneOffset.of(value));
                    continue block25;
                }
                case "min_doc_count": {
                    dateHistogram.minDocCount(Long.parseLong(value));
                    continue block25;
                }
                case "order": {
                    dateHistogram.order("desc".equalsIgnoreCase(value) ? BucketOrder.key((boolean)false) : BucketOrder.key((boolean)true));
                    continue block25;
                }
                case "extended_bounds": {
                    String[] bounds = value.split(":");
                    if (bounds.length != 2) continue block25;
                    dateHistogram.extendedBounds(new LongBounds(bounds[0], bounds[1]));
                    continue block25;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block25;
                }
            }
            throw new SqlParseException("date range err or not define field " + kv.toString());
        }
        return dateHistogram;
    }

    private String gettAggNameFromParamsOrAlias(MethodField field) {
        String alias = field.getAlias();
        for (KVValue kv : field.getParams()) {
            if (kv.key == null || !kv.key.equals("alias")) continue;
            alias = kv.value.toString();
        }
        return alias;
    }

    private HistogramAggregationBuilder histogram(MethodField field) throws SqlParseException {
        String aggName = this.gettAggNameFromParamsOrAlias(field);
        HistogramAggregationBuilder histogram = AggregationBuilders.histogram((String)aggName);
        block30: for (KVValue kv : field.getParams()) {
            if (kv.value.toString().contains("doc[")) {
                String script = String.valueOf(kv.value) + "; return " + kv.key;
                histogram.script(new Script(script));
                continue;
            }
            String value = kv.value.toString();
            switch (kv.key.toLowerCase()) {
                case "interval": {
                    histogram.interval((double)Long.parseLong(value));
                    continue block30;
                }
                case "field": {
                    histogram.field(value);
                    continue block30;
                }
                case "min_doc_count": {
                    histogram.minDocCount(Long.parseLong(value));
                    continue block30;
                }
                case "extended_bounds": {
                    String[] bounds = value.split(":");
                    if (bounds.length != 2) continue block30;
                    histogram.extendedBounds((double)Long.valueOf(bounds[0]).longValue(), (double)Long.valueOf(bounds[1]).longValue());
                    continue block30;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block30;
                }
                case "order": {
                    histogram.order(switch (value) {
                        case "key_desc" -> BucketOrder.key((boolean)false);
                        case "count_asc" -> BucketOrder.count((boolean)true);
                        case "count_desc" -> BucketOrder.count((boolean)false);
                        default -> BucketOrder.key((boolean)true);
                    });
                    continue block30;
                }
            }
            throw new SqlParseException("histogram err or not define field " + kv.toString());
        }
        return histogram;
    }

    private RangeAggregationBuilder rangeBuilder(MethodField field) {
        LinkedList params = field.getParams().stream().filter(kv -> !"alias".equals(kv.key)).collect(Collectors.toCollection(LinkedList::new));
        String fieldName = ((KVValue)params.poll()).toString();
        double[] ds = Util.KV2DoubleArr(params);
        RangeAggregationBuilder range = (RangeAggregationBuilder)AggregationBuilders.range((String)field.getAlias()).field(fieldName);
        for (int i = 1; i < ds.length; ++i) {
            range.addRange(ds[i - 1], ds[i]);
        }
        return range;
    }

    private ValuesSourceAggregationBuilder makeCountAgg(MethodField field) {
        if (SQLAggregateOption.DISTINCT.equals((Object)field.getOption())) {
            if (field.getParams().size() == 1) {
                return AggregationBuilders.cardinality((String)field.getAlias()).field(field.getParams().get((int)0).value.toString());
            }
            Integer precision_threshold = (Integer)field.getParams().get((int)1).value;
            return AggregationBuilders.cardinality((String)field.getAlias()).precisionThreshold((long)precision_threshold.intValue()).field(field.getParams().get((int)0).value.toString());
        }
        String fieldName = field.getParams().get((int)0).value.toString();
        if ("*".equals(fieldName)) {
            KVValue kvValue = new KVValue(null, "_index");
            field.getParams().set(0, kvValue);
            return AggregationBuilders.count((String)field.getAlias()).field(kvValue.toString());
        }
        return AggregationBuilders.count((String)field.getAlias()).field(fieldName);
    }

    private AbstractAggregationBuilder makeTopHitsAgg(MethodField field) {
        String alias = this.gettAggNameFromParamsOrAlias(field);
        TopHitsAggregationBuilder topHits = AggregationBuilders.topHits((String)alias);
        List<KVValue> params = field.getParams();
        String[] include = null;
        String[] exclude = null;
        block17: for (KVValue kv : params) {
            switch (kv.key) {
                case "from": {
                    topHits.from(((Integer)kv.value).intValue());
                    continue block17;
                }
                case "size": {
                    topHits.size(((Integer)kv.value).intValue());
                    continue block17;
                }
                case "include": {
                    include = kv.value.toString().split(",");
                    continue block17;
                }
                case "exclude": {
                    exclude = kv.value.toString().split(",");
                    continue block17;
                }
                case "alias": 
                case "nested": 
                case "reverse_nested": 
                case "children": {
                    continue block17;
                }
            }
            topHits.sort(kv.key, SortOrder.valueOf((String)kv.value.toString().toUpperCase()));
        }
        if (include != null || exclude != null) {
            topHits.fetchSource(include, exclude);
        }
        return topHits;
    }

    public Map<String, KVValue> getGroupMap() {
        return this.groupMap;
    }

    private AggregationBuilder wrapWithFilterAgg(NestedType nestedType, ValuesSourceAggregationBuilder builder) throws SqlParseException {
        List<Condition> nestedConditionList;
        if (this.where != null && this.where.getWheres() != null && !(nestedConditionList = this.where.getWheres().stream().filter(condition -> condition instanceof Condition).map(condition -> (Condition)condition).filter(condition -> condition.isNestedComplex() || nestedType.path.equalsIgnoreCase(condition.getNestedPath())).filter(condition -> Where.CONN.AND.equals((Object)condition.getConn())).collect(Collectors.toList())).isEmpty()) {
            Where filterWhere = new Where(this.where.getConn());
            nestedConditionList.forEach(condition -> {
                if (condition.isNestedComplex()) {
                    ((Where)condition.getValue()).getWheres().forEach(filterWhere::addWhere);
                } else {
                    condition.setNested(false);
                    condition.setNestedPath("");
                    filterWhere.addWhere((Where)condition);
                }
            });
            FilterAggregationBuilder filterAgg = AggregationBuilders.filter((String)nestedType.getFilterAggName(), (QueryBuilder)QueryMaker.explain(filterWhere));
            nestedType.addBucketPath(Path.getAggPath(filterAgg.getName()));
            return filterAgg.subAggregation((AggregationBuilder)builder);
        }
        return builder;
    }

    private void extendGroupMap(Field field, KVValue value) {
        this.groupMap.put(field.toString(), value);
        if (!StringUtils.isEmpty(field.getAlias())) {
            this.groupMap.putIfAbsent(field.getAlias(), value);
        }
    }
}

