/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.alias;

import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.opensearch.sql.legacy.rewriter.RewriteRule;
import org.opensearch.sql.legacy.rewriter.alias.Identifier;
import org.opensearch.sql.legacy.rewriter.alias.Table;
import org.opensearch.sql.legacy.rewriter.subquery.utils.FindSubQuery;

public class TableAliasPrefixRemoveRule
implements RewriteRule<SQLQueryExpr> {
    private final Set<String> tableAliasesToRemove = new HashSet<String>();

    @Override
    public boolean match(SQLQueryExpr root) {
        if (this.hasSubQuery(root)) {
            return false;
        }
        this.collectTableAliasesThatCanBeRemoved(root);
        return !this.tableAliasesToRemove.isEmpty();
    }

    @Override
    public void rewrite(SQLQueryExpr root) {
        this.removeTableAliasPrefixInColumnName(root);
    }

    private boolean hasSubQuery(SQLQueryExpr root) {
        FindSubQuery visitor2 = new FindSubQuery();
        root.accept(visitor2);
        return visitor2.hasSubQuery();
    }

    private void collectTableAliasesThatCanBeRemoved(SQLQueryExpr root) {
        this.visitNonJoinedTable(root, tableExpr -> {
            Table table = new Table((SQLExprTableSource)tableExpr);
            if (table.hasAlias()) {
                this.tableAliasesToRemove.add(table.alias());
                table.removeAlias();
            } else {
                this.tableAliasesToRemove.add(table.name());
            }
        });
    }

    private void removeTableAliasPrefixInColumnName(SQLQueryExpr root) {
        this.visitColumnName(root, idExpr -> {
            Identifier field = new Identifier((SQLIdentifierExpr)idExpr);
            if (field.hasPrefix() && this.tableAliasesToRemove.contains(field.prefix())) {
                field.removePrefix();
            }
        });
    }

    private void visitNonJoinedTable(SQLQueryExpr root, final Consumer<SQLExprTableSource> visit) {
        root.accept(new MySqlASTVisitorAdapter(this){

            @Override
            public boolean visit(SQLJoinTableSource x) {
                return false;
            }

            @Override
            public void endVisit(SQLExprTableSource tableExpr) {
                visit.accept(tableExpr);
            }
        });
    }

    private void visitColumnName(SQLQueryExpr expr, final Consumer<SQLIdentifierExpr> visit) {
        expr.accept(new MySqlASTVisitorAdapter(this){

            @Override
            public boolean visit(SQLExprTableSource x) {
                return false;
            }

            @Override
            public void endVisit(SQLIdentifierExpr idExpr) {
                visit.accept(idExpr);
            }
        });
    }
}

