/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.OpenSearchStorageEngine;

public class OpenSearchScrollRequest
implements OpenSearchRequest {
    private final transient SearchRequest initialSearchRequest;
    private final TimeValue scrollTimeout;
    private final OpenSearchRequest.IndexName indexName;
    private final OpenSearchExprValueFactory exprValueFactory;
    private String scrollId = "";
    public static final String NO_SCROLL_ID = "";
    private boolean needClean = true;
    private final List<String> includes;

    public OpenSearchScrollRequest(OpenSearchRequest.IndexName indexName, TimeValue scrollTimeout, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory exprValueFactory, List<String> includes) {
        this.indexName = indexName;
        this.scrollTimeout = scrollTimeout;
        this.exprValueFactory = exprValueFactory;
        this.initialSearchRequest = new SearchRequest().indices(indexName.getIndexNames()).scroll(scrollTimeout).source(sourceBuilder);
        this.includes = includes;
    }

    @Override
    public OpenSearchResponse search(Function<SearchRequest, SearchResponse> searchAction, Function<SearchScrollRequest, SearchResponse> scrollAction) {
        SearchResponse openSearchResponse;
        if (this.isScroll()) {
            openSearchResponse = scrollAction.apply(this.scrollRequest());
        } else {
            if (this.initialSearchRequest == null) {
                throw new UnsupportedOperationException("Misuse of OpenSearchScrollRequest");
            }
            openSearchResponse = searchAction.apply(this.initialSearchRequest);
        }
        OpenSearchResponse response = new OpenSearchResponse(openSearchResponse, this.exprValueFactory, this.includes);
        this.needClean = response.isEmpty();
        if (!this.needClean) {
            this.setScrollId(openSearchResponse.getScrollId());
        }
        return response;
    }

    @Override
    public void clean(Consumer<String> cleanAction) {
        try {
            if (this.needClean && this.isScroll()) {
                cleanAction.accept(this.getScrollId());
                this.setScrollId(NO_SCROLL_ID);
            }
        }
        finally {
            this.reset();
        }
    }

    public boolean isScroll() {
        return !this.scrollId.equals(NO_SCROLL_ID);
    }

    public SearchScrollRequest scrollRequest() {
        Objects.requireNonNull(this.scrollId, "Scroll id cannot be null");
        return new SearchScrollRequest().scroll(this.scrollTimeout).scrollId(this.scrollId);
    }

    public void reset() {
        this.scrollId = NO_SCROLL_ID;
    }

    @Override
    public boolean hasAnotherBatch() {
        return !this.needClean && !this.scrollId.equals(NO_SCROLL_ID);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.scrollTimeout);
        out.writeString(this.scrollId);
        out.writeStringCollection(this.includes);
        this.indexName.writeTo(out);
    }

    public OpenSearchScrollRequest(StreamInput in, OpenSearchStorageEngine engine) throws IOException {
        this.initialSearchRequest = null;
        this.scrollTimeout = in.readTimeValue();
        this.scrollId = in.readString();
        this.includes = in.readStringList();
        this.indexName = new OpenSearchRequest.IndexName(in);
        OpenSearchIndex index = (OpenSearchIndex)engine.getTable(null, this.indexName.toString());
        this.exprValueFactory = new OpenSearchExprValueFactory(index.getFieldOpenSearchTypes(), index.isFieldTypeTolerance());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchScrollRequest)) {
            return false;
        }
        OpenSearchScrollRequest other = (OpenSearchScrollRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimeValue this$scrollTimeout = this.getScrollTimeout();
        TimeValue other$scrollTimeout = other.getScrollTimeout();
        if (this$scrollTimeout == null ? other$scrollTimeout != null : !this$scrollTimeout.equals(other$scrollTimeout)) {
            return false;
        }
        OpenSearchRequest.IndexName this$indexName = this.getIndexName();
        OpenSearchRequest.IndexName other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !((Object)this$indexName).equals(other$indexName)) {
            return false;
        }
        String this$scrollId = this.getScrollId();
        String other$scrollId = other.getScrollId();
        return !(this$scrollId == null ? other$scrollId != null : !this$scrollId.equals(other$scrollId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchScrollRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        TimeValue $scrollTimeout = this.getScrollTimeout();
        result2 = result2 * 59 + ($scrollTimeout == null ? 43 : $scrollTimeout.hashCode());
        OpenSearchRequest.IndexName $indexName = this.getIndexName();
        result2 = result2 * 59 + ($indexName == null ? 43 : ((Object)$indexName).hashCode());
        String $scrollId = this.getScrollId();
        result2 = result2 * 59 + ($scrollId == null ? 43 : $scrollId.hashCode());
        return result2;
    }

    @Generated
    public SearchRequest getInitialSearchRequest() {
        return this.initialSearchRequest;
    }

    @Generated
    public TimeValue getScrollTimeout() {
        return this.scrollTimeout;
    }

    @Generated
    public OpenSearchRequest.IndexName getIndexName() {
        return this.indexName;
    }

    @Override
    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public boolean isNeedClean() {
        return this.needClean;
    }

    @Generated
    public String toString() {
        return "OpenSearchScrollRequest(initialSearchRequest=" + String.valueOf(this.getInitialSearchRequest()) + ", scrollTimeout=" + String.valueOf(this.getScrollTimeout()) + ", indexName=" + String.valueOf(this.getIndexName()) + ", scrollId=" + this.getScrollId() + ", needClean=" + this.isNeedClean() + ")";
    }

    @Generated
    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    @Generated
    public String getScrollId() {
        return this.scrollId;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }
}

