/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.sql.executor.execution.QueryPlanFactory;
import org.opensearch.sql.sql.antlr.SQLSyntaxParser;
import org.opensearch.sql.sql.domain.SQLQueryRequest;
import org.opensearch.sql.sql.parser.AstBuilder;
import org.opensearch.sql.sql.parser.AstStatementBuilder;

public class SQLService {
    private final SQLSyntaxParser parser;
    private final QueryManager queryManager;
    private final QueryPlanFactory queryExecutionFactory;
    private final QueryType SQL_QUERY = QueryType.SQL;

    public void execute(SQLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> queryListener, ResponseListener<ExecutionEngine.ExplainResponse> explainListener) {
        try {
            this.queryManager.submit(this.plan(request, queryListener, explainListener));
        }
        catch (Exception e) {
            queryListener.onFailure(e);
        }
    }

    public void explain(SQLQueryRequest request, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.queryManager.submit(this.plan(request, QueryPlanFactory.NO_CONSUMER_RESPONSE_LISTENER, listener));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private AbstractPlan plan(SQLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> queryListener, ResponseListener<ExecutionEngine.ExplainResponse> explainListener) {
        boolean isExplainRequest = request.isExplainRequest();
        if (request.getCursor().isPresent()) {
            if (isExplainRequest) {
                throw new UnsupportedOperationException("Explain of a paged query continuation is not supported. Use `explain` for the initial query request.");
            }
            if (request.isCursorCloseRequest()) {
                return this.queryExecutionFactory.createCloseCursor(request.getCursor().get(), this.SQL_QUERY, queryListener);
            }
            return this.queryExecutionFactory.create(request.getCursor().get(), isExplainRequest, this.SQL_QUERY, request.getFormat(), queryListener, explainListener);
        }
        ParseTree cst = this.parser.parse(request.getQuery());
        Statement statement = cst.accept(new AstStatementBuilder(new AstBuilder(request.getQuery()), AstStatementBuilder.StatementBuilderContext.builder().isExplain(isExplainRequest).fetchSize(request.getFetchSize()).format(request.getFormat()).build()));
        return this.queryExecutionFactory.create(statement, queryListener, explainListener);
    }

    @Generated
    public SQLService(SQLSyntaxParser parser, QueryManager queryManager, QueryPlanFactory queryExecutionFactory) {
        this.parser = parser;
        this.queryManager = queryManager;
        this.queryExecutionFactory = queryExecutionFactory;
    }
}

