/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidthCentered;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside2;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.ConditionStyle;

class FtileIfLongHorizontal
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final List<Ftile> couples = new ArrayList<Ftile>();
    private final Rainbow arrowColor;

    private FtileIfLongHorizontal(List<Ftile> diamonds, List<Double> inlabelSizes, List<Ftile> tiles, Ftile tile2, Rainbow arrowColor) {
        super(tiles.get(0).skinParam());
        if (diamonds.size() != tiles.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < diamonds.size(); ++i) {
            Ftile diamond = diamonds.get(i);
            FtileAssemblySimple tmp = new FtileAssemblySimple(diamond, tiles.get(i));
            this.couples.add(FtileUtils.addHorizontalMargin(tmp, inlabelSizes.get(i), 0.0));
        }
        this.tile2 = tile2;
        this.diamonds = new ArrayList<Ftile>(diamonds);
        this.tiles = new ArrayList<Ftile>(tiles);
        this.arrowColor = arrowColor;
    }

    private static List<Ftile> alignDiamonds(List<Ftile> diamonds, StringBounder stringBounder) {
        double maxOutY = FtileIfLongHorizontal.getMaxOutY(diamonds, stringBounder);
        ArrayList<Ftile> result = new ArrayList<Ftile>();
        for (int i = 0; i < diamonds.size(); ++i) {
            Ftile diamond = diamonds.get(i);
            double missing = maxOutY - diamond.calculateDimension(stringBounder).getOutY();
            assert (missing >= 0.0);
            diamond = FtileUtils.addVerticalMargin(diamond, missing / 2.0, 20.0);
            result.add(diamond);
        }
        return result;
    }

    private static double getMaxOutY(List<Ftile> diamonds, StringBounder stringBounder) {
        double maxOutY = 0.0;
        for (Ftile diamond : diamonds) {
            maxOutY = Math.max(maxOutY, diamond.calculateDimension(stringBounder).getOutY());
        }
        return maxOutY;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        for (Ftile tile : this.couples) {
            result.addAll(tile.getSwimlanes());
        }
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.couples.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HColor backColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> thens, Branch branch2, LinkRendering topInlinkRendering, LinkRendering afterEndwhile, Style styleArrow, Style styleDiamond) {
        boolean horizontalOut;
        Branch branch;
        Rainbow rainbowIn;
        Objects.requireNonNull(afterEndwhile);
        HColor borderColor = styleDiamond.value(PName.LineColor).asColor(ftileFactory.skinParam().getIHtmlColorSet());
        Rainbow arrowColor = Rainbow.build(styleArrow, ftileFactory.skinParam().getIHtmlColorSet());
        FontConfiguration fcTest = styleDiamond.getFontConfiguration(ftileFactory.skinParam().getIHtmlColorSet());
        FontConfiguration fcArrow = styleArrow.getFontConfiguration(ftileFactory.skinParam().getIHtmlColorSet());
        ArrayList<Ftile> tiles = new ArrayList<Ftile>();
        for (Branch branch3 : thens) {
            tiles.add(new FtileMinWidthCentered(branch3.getFtile(), 30.0));
        }
        FtileMinWidthCentered tile2 = new FtileMinWidthCentered(branch2.getFtile(), 30.0);
        List<Ftile> diamonds = new ArrayList<Ftile>();
        ArrayList<Double> inlabelSizes = new ArrayList<Double>();
        for (Branch branch4 : thens) {
            TextBlock tb1 = branch4.getDisplayPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            LineBreakStrategy lineBreak = styleDiamond.wrapWidth();
            TextBlock tbTest = branch4.getLabelTest().create0(fcTest, ftileFactory.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), ftileFactory.skinParam(), lineBreak, CreoleMode.FULL, null, null);
            HColor diamondColor = branch4.getColor() == null ? backColor : branch4.getColor();
            FtileDiamondInside2 diamond = new FtileDiamondInside2(tbTest, branch4.skinParam(), diamondColor, borderColor, swimlane);
            TextBlock tbInlabel = null;
            if (Display.isNull(branch4.getInlabel())) {
                inlabelSizes.add(0.0);
            } else {
                tbInlabel = branch4.getInlabel().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
                inlabelSizes.add(tbInlabel.calculateDimension(ftileFactory.getStringBounder()).getWidth());
                diamond = diamond.withWest(tbInlabel);
            }
            diamond = diamond.withNorth(tb1);
            diamonds.add(diamond);
        }
        TextBlock tb2 = branch2.getDisplayPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        int last = diamonds.size() - 1;
        diamonds.set(last, ((FtileDiamondInside2)diamonds.get(last)).withEast(tb2));
        diamonds = FtileIfLongHorizontal.alignDiamonds(diamonds, ftileFactory.getStringBounder());
        FtileIfLongHorizontal result = new FtileIfLongHorizontal(diamonds, inlabelSizes, tiles, tile2, arrowColor);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        int nbOut = 0;
        for (int i = 0; i < thens.size(); ++i) {
            Ftile ftile = (Ftile)tiles.get(i);
            Ftile diam = diamonds.get(i);
            rainbowIn = thens.get(i).getInColor(arrowColor);
            branch = thens.get(i);
            if (branch.getFtile().calculateDimension(ftileFactory.getStringBounder()).hasPointOut()) {
                ++nbOut;
            }
            Rainbow rainbowOut = branch.getOut();
            TextBlock out2 = null;
            if (branch.getSpecial() != null) {
                out2 = branch.getSpecial().getDisplay().create(fcTest, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            }
            Rainbow rainbow1 = rainbowIn.size() == 0 ? arrowColor : rainbowIn;
            Rainbow rainbow2 = rainbowOut.size() == 0 ? arrowColor : rainbowOut;
            FtileIfLongHorizontal ftileIfLongHorizontal = result;
            Objects.requireNonNull(ftileIfLongHorizontal);
            conns.add(ftileIfLongHorizontal.new ConnectionVerticalIn(diam, ftile, rainbow1));
            FtileIfLongHorizontal ftileIfLongHorizontal2 = result;
            Objects.requireNonNull(ftileIfLongHorizontal2);
            conns.add(ftileIfLongHorizontal2.new ConnectionVerticalOut(ftile, rainbow2, out2));
        }
        Rainbow topInColor = topInlinkRendering.getRainbow(arrowColor);
        for (int i = 0; i < diamonds.size() - 1; ++i) {
            Ftile diam1 = diamonds.get(i);
            Ftile diam2 = diamonds.get(i + 1);
            branch = thens.get(i + 1);
            FtileIfLongHorizontal ftileIfLongHorizontal = result;
            Objects.requireNonNull(ftileIfLongHorizontal);
            conns.add(ftileIfLongHorizontal.new ConnectionHorizontal(diam1, diam2, branch.getInRainbow(arrowColor)));
        }
        FtileIfLongHorizontal ftileIfLongHorizontal = result;
        Objects.requireNonNull(ftileIfLongHorizontal);
        conns.add(ftileIfLongHorizontal.new ConnectionIn(topInColor));
        TextBlock out2 = null;
        if (branch2.getSpecial() != null) {
            out2 = branch2.getSpecial().getDisplay().create(fcTest, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        }
        Rainbow rainbowOut = branch2.getOut();
        rainbowIn = branch2.getInColor(arrowColor);
        Rainbow rainbow1 = rainbowIn.size() == 0 ? arrowColor : rainbowIn;
        Rainbow rainbow2 = rainbowOut.size() == 0 ? arrowColor : rainbowOut;
        FtileIfLongHorizontal ftileIfLongHorizontal3 = result;
        Objects.requireNonNull(ftileIfLongHorizontal3);
        conns.add(ftileIfLongHorizontal3.new ConnectionLastElseIn(rainbow1));
        FtileIfLongHorizontal ftileIfLongHorizontal4 = result;
        Objects.requireNonNull(ftileIfLongHorizontal4);
        conns.add(ftileIfLongHorizontal4.new ConnectionLastElseOut(rainbow2, out2, nbOut));
        boolean bl = horizontalOut = nbOut > 0;
        if (horizontalOut) {
            Rainbow horizontalOutColor = afterEndwhile.getRainbow(arrowColor);
            FtileIfLongHorizontal ftileIfLongHorizontal5 = result;
            Objects.requireNonNull(ftileIfLongHorizontal5);
            conns.add(ftileIfLongHorizontal5.new ConnectionHline(horizontalOutColor));
        }
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    private static double getYdiamontOutToLeft(FtileGeometry dimDiamond1, StringBounder stringBounder) {
        return (dimDiamond1.getInY() + dimDiamond1.getOutY()) / 2.0;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        ArrayList<Ftile> result = new ArrayList<Ftile>(this.tiles);
        result.add(this.tile2);
        return Collections.unmodifiableList(result);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (this.couples.contains(child)) {
            return this.getTranslateCouple1(child, stringBounder);
        }
        if (this.tiles.contains(child)) {
            return this.getTranslate1(child, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double x2 = ((XDimension2D)dimTotal).getWidth() - ((XDimension2D)dim2).getWidth();
        double h2 = 0.0;
        double y2 = (((XDimension2D)dimTotal).getHeight() - 0.0 - ((XDimension2D)dim2).getHeight()) / 2.0 + 0.0;
        return new UTranslate(x2, y2);
    }

    private UTranslate getTranslateDiamond1(Ftile diamond, StringBounder stringBounder) {
        int idx = this.diamonds.indexOf(diamond);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate trCouple = this.getTranslateCouple1(this.couples.get(idx), stringBounder);
        UTranslate in = this.couples.get(idx).getTranslateFor(diamond, stringBounder);
        return trCouple.compose(in);
    }

    private UTranslate getTranslate1(Ftile tile, StringBounder stringBounder) {
        int idx = this.tiles.indexOf(tile);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate trCouple = this.getTranslateCouple1(this.couples.get(idx), stringBounder);
        UTranslate in = this.couples.get(idx).getTranslateFor(tile, stringBounder);
        return trCouple.compose(in);
    }

    private UTranslate getTranslateCouple1(Ftile candidat, StringBounder stringBounder) {
        double x1 = 0.0;
        for (Ftile couple : this.couples) {
            FtileGeometry dim1 = couple.calculateDimension(stringBounder);
            if (couple == candidat) {
                return new UTranslate(x1, 25.0);
            }
            x1 += dim1.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile couple : this.couples) {
            ug.apply(this.getTranslateCouple1(couple, stringBounder)).draw(couple);
        }
        ug.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        double maxOutY = FtileIfLongHorizontal.getMaxOutY(this.diamonds, stringBounder);
        XDimension2D result = new XDimension2D(0.0, 0.0);
        for (Ftile couple : this.couples) {
            result = result.mergeLR(couple.calculateDimension(stringBounder));
        }
        XDimension2D dimTile2 = this.tile2.calculateDimension(stringBounder);
        dimTile2 = dimTile2.delta(0.0, this.getDiamondsHeight(stringBounder) / 2.0);
        result = result.mergeLR(dimTile2);
        result = result.delta(20.0 * (double)this.couples.size(), Math.max(100.0, maxOutY));
        return new FtileGeometry(result, result.getWidth() / 2.0, 0.0);
    }

    private double getDiamondsHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Ftile diamond : this.diamonds) {
            height = Math.max(height, diamond.calculateDimension(stringBounder).getHeight());
        }
        return height;
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> all = new ArrayList<Ftile>(this.tiles);
        all.add(this.tile2);
        for (Ftile tmp : all) {
            if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(dimTotal, ((XDimension2D)dimTotal).getWidth() / 2.0, 0.0, ((XDimension2D)dimTotal).getHeight());
        }
        return new FtileGeometry(dimTotal, ((XDimension2D)dimTotal).getWidth() / 2.0, 0.0);
    }

    class ConnectionVerticalIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow color;

        public ConnectionVerticalIn(Ftile diamond, Ftile tile, Rainbow color) {
            super(diamond, tile);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.color, FtileIfLongHorizontal.this.skinParam().arrows().asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            XPoint2D p = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            XPoint2D p = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(p);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            XPoint2D p1 = this.getP1(ug.getStringBounder());
            XPoint2D p2 = this.getP2(ug.getStringBounder());
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.color, FtileIfLongHorizontal.this.skinParam().arrows().asToDown());
            XPoint2D mp1a = translate1.getTranslated(p1);
            XPoint2D mp2b = translate2.getTranslated(p2);
            double middle = mp1a.getY() + 4.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionVerticalOut
    extends AbstractConnection {
        private final Rainbow color;
        private final TextBlock out2;

        public ConnectionVerticalOut(Ftile tile, Rainbow color, TextBlock out2) {
            super(tile, null);
            this.color = color;
            this.out2 = out2;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            double totalHeight = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            XPoint2D p1 = this.getP1(stringBounder);
            if (p1 == null) {
                return;
            }
            XPoint2D p2 = new XPoint2D(p1.getX(), totalHeight);
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.color, FtileIfLongHorizontal.this.skinParam().arrows().asToDown()).withLabel(this.out2, this.arrowHorizontalAlignment());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return null;
            }
            XPoint2D p = geo.getPointOut();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionHorizontal(Ftile diam1, Ftile diam2, Rainbow color) {
            super(diam1, diam2);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            XPoint2D p1 = this.getP1(stringBounder);
            XPoint2D p2 = this.getP2(stringBounder);
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.color, FtileIfLongHorizontal.this.skinParam().arrows().asToRight());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(dimDiamond1.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(dimDiamond1, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private XPoint2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile2().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(0.0, FtileIfLongHorizontal.getYdiamontOutToLeft(dimDiamond1, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow arrowColor) {
            super(null, (Ftile)FtileIfLongHorizontal.this.diamonds.get(0));
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            UTranslate tr = FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), ug.getStringBounder());
            XPoint2D p2 = tr.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.arrowColor, FtileIfLongHorizontal.this.skinParam().arrows().asToDown());
            XPoint2D p1 = FtileIfLongHorizontal.this.calculateDimensionInternal(ug.getStringBounder()).getPointIn();
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionLastElseIn
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionLastElseIn(Rainbow arrowColor) {
            super((Ftile)FtileIfLongHorizontal.this.diamonds.get(FtileIfLongHorizontal.this.diamonds.size() - 1), FtileIfLongHorizontal.this.tile2);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            XPoint2D p1 = this.getP1(ug.getStringBounder());
            UTranslate tr2 = FtileIfLongHorizontal.this.getTranslate2(ug.getStringBounder());
            XPoint2D p2 = tr2.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.arrowColor, FtileIfLongHorizontal.this.skinParam().arrows().asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private XPoint2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            XPoint2D p = new XPoint2D(dimDiamond1.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(dimDiamond1, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock out2;
        private final int nbOut;

        public ConnectionLastElseOut(Rainbow arrowColor, TextBlock out2, int nbOut) {
            super(FtileIfLongHorizontal.this.tile2, null);
            this.arrowColor = arrowColor;
            this.out2 = out2;
            this.nbOut = nbOut;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            UTranslate tr1 = FtileIfLongHorizontal.this.getTranslate2(stringBounder);
            FtileGeometry dim = this.getFtile1().calculateDimension(stringBounder);
            if (!dim.hasPointOut()) {
                return;
            }
            XPoint2D p1 = tr1.getTranslated(dim.getPointOut());
            FtileGeometry full = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder);
            double totalHeight = full.getHeight();
            XPoint2D p2 = new XPoint2D(p1.getX(), totalHeight);
            Snake snake = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.arrowColor, FtileIfLongHorizontal.this.skinParam().arrows().asToDown()).withLabel(this.out2, this.arrowHorizontalAlignment());
            snake.addPoint(p1);
            snake.addPoint(p2);
            if (this.nbOut == 0) {
                snake.addPoint(new XPoint2D(full.getLeft(), totalHeight));
            }
            ug.draw(snake);
        }
    }

    class ConnectionHline
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionHline(Rainbow arrowColor) {
            super(null, null);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            double[] minmax;
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry totalDim = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder);
            ArrayList<Ftile> allTiles = new ArrayList<Ftile>(FtileIfLongHorizontal.this.couples);
            allTiles.add(FtileIfLongHorizontal.this.tile2);
            if (ug instanceof UGraphicInterceptorOneSwimlane) {
                UGraphicInterceptorOneSwimlane interceptor = (UGraphicInterceptorOneSwimlane)ug;
                List<Swimlane> allSwimlanes = interceptor.getOrderedListOfAllSwimlanes();
                minmax = this.getMinmax(stringBounder, ((XDimension2D)totalDim).getWidth(), allTiles, interceptor.getSwimlane(), allSwimlanes);
            } else {
                minmax = this.getMinmaxSimple(stringBounder, ((XDimension2D)totalDim).getWidth(), allTiles);
            }
            double minX = minmax[0];
            double maxX = minmax[1];
            if (Double.isNaN(minX) || Double.isNaN(maxX)) {
                return;
            }
            Snake s2 = Snake.create(FtileIfLongHorizontal.this.skinParam(), this.arrowColor).withMerge(MergeStrategy.NONE);
            s2.addPoint(minX, ((XDimension2D)totalDim).getHeight());
            s2.addPoint(maxX, ((XDimension2D)totalDim).getHeight());
            ug.draw(s2);
        }

        private Double getLeftOut(StringBounder stringBounder) {
            FtileGeometry dim = FtileIfLongHorizontal.this.calculateDimension(stringBounder);
            if (dim.hasPointOut()) {
                return dim.getLeft();
            }
            return null;
        }

        private double[] getMinmax(StringBounder stringBounder, double width, List<Ftile> allTiles, Swimlane intoSw, List<Swimlane> allSwimlanes) {
            int current = allSwimlanes.indexOf(intoSw);
            Double leftOut = this.getLeftOut(stringBounder);
            if (leftOut == null) {
                return new double[]{Double.NaN, Double.NaN};
            }
            if (current == -1) {
                throw new IllegalStateException();
            }
            int first = this.getFirstSwimlane(stringBounder, allTiles, allSwimlanes);
            int last = this.getLastSwimlane(stringBounder, allTiles, allSwimlanes);
            if (current < first || current > last) {
                return new double[]{Double.NaN, Double.NaN};
            }
            double minX = current != first ? 0.0 : width;
            double maxX = current != last ? width : 0.0;
            minX = Math.min(minX, leftOut);
            maxX = Math.max(maxX, leftOut);
            for (Ftile tmp : allTiles) {
                if (!tmp.calculateDimension(stringBounder).hasPointOut() || !this.ftileDoesOutcomeInThatSwimlane(tmp, intoSw)) continue;
                UTranslate ut = FtileIfLongHorizontal.this.getTranslateFor(tmp, stringBounder);
                double out = tmp.calculateDimension(stringBounder).translate(ut).getLeft();
                minX = Math.min(minX, out);
                maxX = Math.max(maxX, out);
            }
            return new double[]{minX, maxX};
        }

        private double[] getMinmaxSimple(StringBounder stringBounder, double width, List<Ftile> allTiles) {
            Double leftOut = this.getLeftOut(stringBounder);
            if (leftOut == null) {
                return new double[]{Double.NaN, Double.NaN};
            }
            double minX = width / 2.0;
            double maxX = width / 2.0;
            minX = Math.min(minX, leftOut);
            maxX = Math.max(maxX, leftOut);
            for (Ftile tmp : allTiles) {
                if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
                UTranslate ut = FtileIfLongHorizontal.this.getTranslateFor(tmp, stringBounder);
                double out = tmp.calculateDimension(stringBounder).translate(ut).getLeft();
                minX = Math.min(minX, out);
                maxX = Math.max(maxX, out);
            }
            return new double[]{minX, maxX};
        }

        private int getFirstSwimlane(StringBounder stringBounder, List<Ftile> allTiles, List<Swimlane> allSwimlanes) {
            for (int i = 0; i < allSwimlanes.size(); ++i) {
                if (!this.atLeastOne(stringBounder, allSwimlanes.get(i), allTiles)) continue;
                return i;
            }
            throw new IllegalStateException();
        }

        private int getLastSwimlane(StringBounder stringBounder, List<Ftile> allTiles, List<Swimlane> allSwimlanes) {
            for (int i = allSwimlanes.size() - 1; i >= 0; --i) {
                if (!this.atLeastOne(stringBounder, allSwimlanes.get(i), allTiles)) continue;
                return i;
            }
            throw new IllegalStateException();
        }

        private boolean atLeastOne(StringBounder stringBounder, Swimlane intoSw, List<Ftile> allTiles) {
            for (Ftile tmp : allTiles) {
                if (!tmp.calculateDimension(stringBounder).hasPointOut() || !this.ftileDoesOutcomeInThatSwimlane(tmp, intoSw)) continue;
                return true;
            }
            return false;
        }

        private boolean ftileDoesOutcomeInThatSwimlane(Ftile ftile, Swimlane swimlane) {
            return ftile.getSwimlaneOut() == swimlane && ftile.getSwimlanes().contains(swimlane);
        }
    }
}

