// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const typeGuards = require('./typeGuards.cjs');

const IS_UNICODE_RANGE = /^unicode-range$/i;
const IS_AT_FONT_FACE = /^font-face$/i;

/**
 * Check whether a declaration is the `unicode-range` descriptor of an `@font-face` rule.
 *
 * @param {import('postcss').Declaration} decl
 * @returns {boolean}
 */
function isUnicodeRangeDescriptor(decl) {
	if (!IS_UNICODE_RANGE.test(decl.prop)) {
		return false;
	}

	const parent = decl.parent;

	if (!parent || !typeGuards.isAtRule(parent)) {
		return false;
	}

	return IS_AT_FONT_FACE.test(parent.name);
}

module.exports = isUnicodeRangeDescriptor;
