/*
 * SPDX-FileCopyrightText: Copyright (c) 2016-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT! */

#include "core/bin_data.h"
#include "rmflcnbl.h"
#include "nvBinSegment.h"
#include "../src/kernel/core/bin_data_pvt.h"

//
// Forward declarations.
// These are needed for generating the bindata access functions, which use
// "struct X" as a parameter. This is easier than #include-ing all the necessary
// headers. TODO: consider sharing a list of forward struct declarations with
// e.g. eng_desc.h?
//

struct KernelPmu;
struct KernelGsp;
struct KernelSec2;
struct KernelGsplite;
struct Spdm;

//
// Default segment for bindata to put the data arrays to paged memory.
// This segment is never locked.
//
CONS_SEGMENT("PAGErGEN")

#if !defined(NVLOG_PARSING)

typedef enum
{
    BINDATA_INDEX_ZERO_UNUSED                                                                                      = 0,
    __idx_kgspBinArchiveGspRmBoot_TU102_BINDATA_LABEL_UCODE_IMAGE                                                  = 1,
    __idx_kgspBinArchiveGspRmBoot_TU102_BINDATA_LABEL_UCODE_DESC                                                   = 2,
    __idx_kgspBinArchiveGspRmBoot_GA100_BINDATA_LABEL_UCODE_IMAGE                                                  = 3,
    __idx_kgspBinArchiveGspRmBoot_GA100_BINDATA_LABEL_UCODE_DESC                                                   = 4,
    __idx_kgspBinArchiveGspRmBoot_GA102_BINDATA_LABEL_UCODE_IMAGE_DBG                                              = 5,
    __idx_kgspBinArchiveGspRmBoot_GA102_BINDATA_LABEL_UCODE_DESC_DBG                                               = 6,
    __idx_kgspBinArchiveGspRmBoot_GA102_BINDATA_LABEL_UCODE_IMAGE_PROD                                             = 7,
    __idx_kgspBinArchiveGspRmBoot_GA102_BINDATA_LABEL_UCODE_DESC_PROD                                              = 8,
    __idx_kgspBinArchiveGspRmBoot_AD102_BINDATA_LABEL_UCODE_IMAGE_DBG                                              = 9,
    __idx_kgspBinArchiveGspRmBoot_AD102_BINDATA_LABEL_UCODE_DESC_DBG                                               = 10,
    __idx_kgspBinArchiveGspRmBoot_AD102_BINDATA_LABEL_UCODE_IMAGE_PROD                                             = 11,
    __idx_kgspBinArchiveGspRmBoot_AD102_BINDATA_LABEL_UCODE_DESC_PROD                                              = 12,
    __idx_kgspBinArchiveGspRmBoot_GH100_BINDATA_LABEL_UCODE_IMAGE_DBG                                              = 13,
    __idx_kgspBinArchiveGspRmBoot_GH100_BINDATA_LABEL_UCODE_DESC_DBG                                               = 14,
    __idx_kgspBinArchiveGspRmBoot_GH100_BINDATA_LABEL_UCODE_IMAGE_PROD                                             = 15,
    __idx_kgspBinArchiveGspRmBoot_GH100_BINDATA_LABEL_UCODE_DESC_PROD                                              = 16,
    __idx_kgspBinArchiveGspRmBoot_GB100_BINDATA_LABEL_UCODE_IMAGE_DBG                                              = 17,
    __idx_kgspBinArchiveGspRmBoot_GB100_BINDATA_LABEL_UCODE_DESC_DBG                                               = 18,
    __idx_kgspBinArchiveGspRmBoot_GB100_BINDATA_LABEL_UCODE_IMAGE_PROD                                             = 19,
    __idx_kgspBinArchiveGspRmBoot_GB100_BINDATA_LABEL_UCODE_DESC_PROD                                              = 20,
    __idx_kgspBinArchiveGspRmBoot_GB202_BINDATA_LABEL_UCODE_IMAGE_DBG                                              = 21,
    __idx_kgspBinArchiveGspRmBoot_GB202_BINDATA_LABEL_UCODE_DESC_DBG                                               = 22,
    __idx_kgspBinArchiveGspRmBoot_GB202_BINDATA_LABEL_UCODE_IMAGE_PROD                                             = 23,
    __idx_kgspBinArchiveGspRmBoot_GB202_BINDATA_LABEL_UCODE_DESC_PROD                                              = 24,
    __idx_kgspBinArchiveConcatenatedFMCDesc_GH100_BINDATA_LABEL_UCODE_DESC_PROD                                    = 25,
    __idx_kgspBinArchiveConcatenatedFMCDesc_GB100_BINDATA_LABEL_UCODE_DESC_PROD                                    = 26,
    __idx_kgspBinArchiveConcatenatedFMC_GH100_BINDATA_LABEL_UCODE_IMAGE_PROD                                       = 27,
    __idx_kgspBinArchiveConcatenatedFMC_GB100_BINDATA_LABEL_UCODE_IMAGE_PROD                                       = 28,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_BINDATA_LABEL_UCODE_IMAGE                                     = 29,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_BINDATA_LABEL_UCODE_HASH                                      = 30,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_BINDATA_LABEL_UCODE_SIG                                       = 31,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GH100_BINDATA_LABEL_UCODE_PKEY                                      = 32,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_BINDATA_LABEL_UCODE_IMAGE                                     = 33,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_BINDATA_LABEL_UCODE_HASH                                      = 34,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_BINDATA_LABEL_UCODE_SIG                                       = 35,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB100_BINDATA_LABEL_UCODE_PKEY                                      = 36,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_BINDATA_LABEL_UCODE_IMAGE                                     = 37,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_BINDATA_LABEL_UCODE_HASH                                      = 38,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_BINDATA_LABEL_UCODE_SIG                                       = 39,
    __idx_kgspBinArchiveGspRmFmcGfwDebugSigned_GB202_BINDATA_LABEL_UCODE_PKEY                                      = 40,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_IMAGE                                      = 41,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_HASH                                       = 42,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_SIG                                        = 43,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_PKEY                                       = 44,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_IMAGE                                      = 45,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_HASH                                       = 46,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_SIG                                        = 47,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_PKEY                                       = 48,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_BINDATA_LABEL_UCODE_IMAGE                                      = 49,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_BINDATA_LABEL_UCODE_HASH                                       = 50,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_BINDATA_LABEL_UCODE_SIG                                        = 51,
    __idx_kgspBinArchiveGspRmFmcGfwProdSigned_GB202_BINDATA_LABEL_UCODE_PKEY                                       = 52,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_IMAGE                                    = 53,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_HASH                                     = 54,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_SIG                                      = 55,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GH100_BINDATA_LABEL_UCODE_PKEY                                     = 56,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_IMAGE                                    = 57,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_HASH                                     = 58,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_SIG                                      = 59,
    __idx_kgspBinArchiveGspRmCcFmcGfwProdSigned_GB100_BINDATA_LABEL_UCODE_PKEY                                     = 60,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_IMAGE_DBG                                              = 61,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_HEADER_DBG                                             = 62,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_IMAGE_PROD                                             = 63,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_HEADER_PROD                                            = 64,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_SIG_DBG                                                = 65,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_SIG_PROD                                               = 66,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_PATCH_LOC                                              = 67,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_PATCH_SIG                                              = 68,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_PATCH_META                                             = 69,
    __idx_kgspBinArchiveBooterLoadUcode_TU102_BINDATA_LABEL_NUM_SIGS                                               = 70,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_IMAGE_DBG                                              = 71,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_HEADER_DBG                                             = 72,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_IMAGE_PROD                                             = 73,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_HEADER_PROD                                            = 74,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_SIG_DBG                                                = 75,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_SIG_PROD                                               = 76,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_PATCH_LOC                                              = 77,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_PATCH_SIG                                              = 78,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_PATCH_META                                             = 79,
    __idx_kgspBinArchiveBooterLoadUcode_TU116_BINDATA_LABEL_NUM_SIGS                                               = 80,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_IMAGE_DBG                                              = 81,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_HEADER_DBG                                             = 82,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_IMAGE_PROD                                             = 83,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_HEADER_PROD                                            = 84,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_SIG_DBG                                                = 85,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_SIG_PROD                                               = 86,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_PATCH_LOC                                              = 87,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_PATCH_SIG                                              = 88,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_PATCH_META                                             = 89,
    __idx_kgspBinArchiveBooterLoadUcode_GA100_BINDATA_LABEL_NUM_SIGS                                               = 90,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_IMAGE_DBG                                              = 91,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_HEADER_DBG                                             = 92,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_IMAGE_PROD                                             = 93,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_HEADER_PROD                                            = 94,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_SIG_DBG                                                = 95,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_SIG_PROD                                               = 96,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_PATCH_LOC                                              = 97,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_PATCH_SIG                                              = 98,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_PATCH_META                                             = 99,
    __idx_kgspBinArchiveBooterLoadUcode_GA102_BINDATA_LABEL_NUM_SIGS                                               = 100,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_IMAGE_DBG                                              = 101,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_HEADER_DBG                                             = 102,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_IMAGE_PROD                                             = 103,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_HEADER_PROD                                            = 104,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_SIG_DBG                                                = 105,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_SIG_PROD                                               = 106,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_PATCH_LOC                                              = 107,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_PATCH_SIG                                              = 108,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_PATCH_META                                             = 109,
    __idx_kgspBinArchiveBooterLoadUcode_AD102_BINDATA_LABEL_NUM_SIGS                                               = 110,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_IMAGE_DBG                                            = 111,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_HEADER_DBG                                           = 112,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_IMAGE_PROD                                           = 113,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_HEADER_PROD                                          = 114,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_SIG_DBG                                              = 115,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_SIG_PROD                                             = 116,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_PATCH_LOC                                            = 117,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_PATCH_SIG                                            = 118,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_PATCH_META                                           = 119,
    __idx_kgspBinArchiveBooterUnloadUcode_TU102_BINDATA_LABEL_NUM_SIGS                                             = 120,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_IMAGE_DBG                                            = 121,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_HEADER_DBG                                           = 122,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_IMAGE_PROD                                           = 123,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_HEADER_PROD                                          = 124,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_SIG_DBG                                              = 125,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_SIG_PROD                                             = 126,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_PATCH_LOC                                            = 127,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_PATCH_SIG                                            = 128,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_PATCH_META                                           = 129,
    __idx_kgspBinArchiveBooterUnloadUcode_TU116_BINDATA_LABEL_NUM_SIGS                                             = 130,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_IMAGE_DBG                                            = 131,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_HEADER_DBG                                           = 132,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_IMAGE_PROD                                           = 133,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_HEADER_PROD                                          = 134,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_SIG_DBG                                              = 135,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_SIG_PROD                                             = 136,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_PATCH_LOC                                            = 137,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_PATCH_SIG                                            = 138,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_PATCH_META                                           = 139,
    __idx_kgspBinArchiveBooterUnloadUcode_GA100_BINDATA_LABEL_NUM_SIGS                                             = 140,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_IMAGE_DBG                                            = 141,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_HEADER_DBG                                           = 142,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_IMAGE_PROD                                           = 143,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_HEADER_PROD                                          = 144,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_SIG_DBG                                              = 145,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_SIG_PROD                                             = 146,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_PATCH_LOC                                            = 147,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_PATCH_SIG                                            = 148,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_PATCH_META                                           = 149,
    __idx_kgspBinArchiveBooterUnloadUcode_GA102_BINDATA_LABEL_NUM_SIGS                                             = 150,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_IMAGE_DBG                                            = 151,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_HEADER_DBG                                           = 152,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_IMAGE_PROD                                           = 153,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_HEADER_PROD                                          = 154,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_SIG_DBG                                              = 155,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_SIG_PROD                                             = 156,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_PATCH_LOC                                            = 157,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_PATCH_SIG                                            = 158,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_PATCH_META                                           = 159,
    __idx_kgspBinArchiveBooterUnloadUcode_AD102_BINDATA_LABEL_NUM_SIGS                                             = 160,
    __idx_ksec2BinArchiveBlUcode_TU102_BINDATA_LABEL_UCODE_IMAGE                                                   = 161,
    __idx_ksec2BinArchiveBlUcode_TU102_BINDATA_LABEL_UCODE_DESC                                                    = 162,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_IMAGE_DBG                                            = 163,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_HEADER_DBG                                           = 164,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_IMAGE_PROD                                           = 165,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_HEADER_PROD                                          = 166,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_SIG_DBG                                              = 167,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_SIG_PROD                                             = 168,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_PATCH_LOC                                            = 169,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_PATCH_SIG                                            = 170,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_PATCH_META                                           = 171,
    __idx_ksec2BinArchiveSecurescrubUcode_AD10X_BINDATA_LABEL_NUM_SIGS                                             = 172,
    __idx_spdmBinArchiveL1Certificate_IMPL_BINDATA_LABEL_CERTIFICATE_PEM                                           = 173,
    __idx_spdmBinArchiveL1Certificate_IMPL_BINDATA_LABEL_CERTIFICATE_DER                                           = 174,
    __idx_spdmBinArchiveIndividualL2Certificate_GH100_BINDATA_LABEL_CERTIFICATE_PEM                                = 175,
    __idx_spdmBinArchiveIndividualL2Certificate_GH100_BINDATA_LABEL_CERTIFICATE_DER                                = 176,
    __idx_spdmBinArchiveIndividualL3Certificate_GH100_BINDATA_LABEL_CERTIFICATE_PEM                                = 177,
    __idx_spdmBinArchiveIndividualL3Certificate_GH100_BINDATA_LABEL_CERTIFICATE_DER                                = 178,
    __idx_spdmBinArchiveIndividualL2Certificate_GB100_BINDATA_LABEL_CERTIFICATE_PEM                                = 179,
    __idx_spdmBinArchiveIndividualL2Certificate_GB100_BINDATA_LABEL_CERTIFICATE_DER                                = 180,
    __idx_spdmBinArchiveIndividualL3Certificate_GB100_BINDATA_LABEL_CERTIFICATE_PEM                                = 181,
    __idx_spdmBinArchiveIndividualL3Certificate_GB100_BINDATA_LABEL_CERTIFICATE_DER                                = 182,
    __idx_spdmBinArchiveIndividualL3Certificate_GB102_BINDATA_LABEL_CERTIFICATE_PEM                                = 183,
    __idx_spdmBinArchiveIndividualL3Certificate_GB102_BINDATA_LABEL_CERTIFICATE_DER                                = 184,
    __idx_spdmBinArchiveIndividualL3Certificate_GB110_BINDATA_LABEL_CERTIFICATE_PEM                                = 185,
    __idx_spdmBinArchiveIndividualL3Certificate_GB110_BINDATA_LABEL_CERTIFICATE_DER                                = 186,
    __idx_spdmBinArchiveIndividualL3Certificate_GB112_BINDATA_LABEL_CERTIFICATE_PEM                                = 187,
    __idx_spdmBinArchiveIndividualL3Certificate_GB112_BINDATA_LABEL_CERTIFICATE_DER                                = 188,

    BINDATA_INDEX_END
} bindata_index_t;

struct BINDATA_STORAGE_PVT_ALL
{
#define BINDATA_NO_SEGMENTS
#define BINDATA_INCLUDE_STORAGE_PVT_DECL

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"
#include "g_bindata_spdmGetBinArchiveL1Certificate_IMPL.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB102.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB110.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB112.c"

#undef BINDATA_INCLUDE_STORAGE_PVT_DECL
#undef BINDATA_NO_SEGMENTS
};

// First include the data as it's referenced by storage_pvt
// Also useful to keep the NvU8 data packed together so we can merge multiple
// buffers into a single chunk for allocations.
#define BINDATA_INCLUDE_DATA

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"
#include "g_bindata_spdmGetBinArchiveL1Certificate_IMPL.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB102.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB110.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB112.c"

#undef BINDATA_INCLUDE_DATA

BINDATA_CONST BINDATA_STORAGE_PVT g_bindata_pvt[] =
{
#define BINDATA_NO_SEGMENTS
#define BINDATA_INCLUDE_STORAGE_PVT_DEFN
// Add a dummy entry at index 0 which will be mapped to BINDATA_INDEX_ZERO_UNUSED in bindata_index_t
{
    0,
    0,
    NULL,
    0,
    0,
    0,
},

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"
#include "g_bindata_spdmGetBinArchiveL1Certificate_IMPL.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB102.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB110.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB112.c"

#undef BINDATA_INCLUDE_STORAGE_PVT_DEFN
#undef BINDATA_NO_SEGMENTS
};

const NvU32 g_bindata_pvt_count = sizeof(g_bindata_pvt) / sizeof(BINDATA_STORAGE_PVT);

// Lastly, include everything else..
#define BINDATA_INCLUDE_ARCHIVE
#define BINDATA_INCLUDE_FUNCTION

#include "g_bindata_kgspGetBinArchiveGspRmBoot_TU102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GA102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_AD102.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmBoot_GB202.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMCDesc_GB100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GH100.c"
#include "g_bindata_kgspGetBinArchiveConcatenatedFMC_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwDebugSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveGspRmFmcGfwProdSigned_GB202.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GH100.c"
#include "g_bindata_kgspGetBinArchiveGspRmCcFmcGfwProdSigned_GB100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterLoadUcode_AD102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_TU116.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA100.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_GA102.c"
#include "g_bindata_kgspGetBinArchiveBooterUnloadUcode_AD102.c"
#include "g_bindata_ksec2GetBinArchiveBlUcode_TU102.c"
#include "g_bindata_ksec2GetBinArchiveSecurescrubUcode_AD10X.c"
#include "g_bindata_spdmGetBinArchiveL1Certificate_IMPL.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GH100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL2Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB100.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB102.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB110.c"
#include "g_bindata_spdmGetBinArchiveIndividualL3Certificate_GB112.c"

#undef BINDATA_INCLUDE_FUNCTION
#undef BINDATA_INCLUDE_ARCHIVE

#endif // !defined(NVLOG_PARSING)
