﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>Provides information about a specific version of a message
 * template.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TemplateVersionResponse">AWS
 * API Reference</a></p>
 */
class TemplateVersionResponse {
 public:
  AWS_PINPOINT_API TemplateVersionResponse() = default;
  AWS_PINPOINT_API TemplateVersionResponse(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API TemplateVersionResponse& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The date, in ISO 8601 format, when the version of the message template was
   * created.</p>
   */
  inline const Aws::String& GetCreationDate() const { return m_creationDate; }
  inline bool CreationDateHasBeenSet() const { return m_creationDateHasBeenSet; }
  template <typename CreationDateT = Aws::String>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::String>
  TemplateVersionResponse& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A JSON object that specifies the default values that are used for message
   * variables in the version of the message template. This object is a set of
   * key-value pairs. Each key defines a message variable in the template. The
   * corresponding value defines the default value for that variable.</p>
   */
  inline const Aws::String& GetDefaultSubstitutions() const { return m_defaultSubstitutions; }
  inline bool DefaultSubstitutionsHasBeenSet() const { return m_defaultSubstitutionsHasBeenSet; }
  template <typename DefaultSubstitutionsT = Aws::String>
  void SetDefaultSubstitutions(DefaultSubstitutionsT&& value) {
    m_defaultSubstitutionsHasBeenSet = true;
    m_defaultSubstitutions = std::forward<DefaultSubstitutionsT>(value);
  }
  template <typename DefaultSubstitutionsT = Aws::String>
  TemplateVersionResponse& WithDefaultSubstitutions(DefaultSubstitutionsT&& value) {
    SetDefaultSubstitutions(std::forward<DefaultSubstitutionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date, in ISO 8601 format, when the version of the message template was
   * last modified.</p>
   */
  inline const Aws::String& GetLastModifiedDate() const { return m_lastModifiedDate; }
  inline bool LastModifiedDateHasBeenSet() const { return m_lastModifiedDateHasBeenSet; }
  template <typename LastModifiedDateT = Aws::String>
  void SetLastModifiedDate(LastModifiedDateT&& value) {
    m_lastModifiedDateHasBeenSet = true;
    m_lastModifiedDate = std::forward<LastModifiedDateT>(value);
  }
  template <typename LastModifiedDateT = Aws::String>
  TemplateVersionResponse& WithLastModifiedDate(LastModifiedDateT&& value) {
    SetLastModifiedDate(std::forward<LastModifiedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The custom description of the version of the message template.</p>
   */
  inline const Aws::String& GetTemplateDescription() const { return m_templateDescription; }
  inline bool TemplateDescriptionHasBeenSet() const { return m_templateDescriptionHasBeenSet; }
  template <typename TemplateDescriptionT = Aws::String>
  void SetTemplateDescription(TemplateDescriptionT&& value) {
    m_templateDescriptionHasBeenSet = true;
    m_templateDescription = std::forward<TemplateDescriptionT>(value);
  }
  template <typename TemplateDescriptionT = Aws::String>
  TemplateVersionResponse& WithTemplateDescription(TemplateDescriptionT&& value) {
    SetTemplateDescription(std::forward<TemplateDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the message template.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  TemplateVersionResponse& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of channel that the message template is designed for. Possible
   * values are: EMAIL, PUSH, SMS, INAPP, and VOICE.</p>
   */
  inline const Aws::String& GetTemplateType() const { return m_templateType; }
  inline bool TemplateTypeHasBeenSet() const { return m_templateTypeHasBeenSet; }
  template <typename TemplateTypeT = Aws::String>
  void SetTemplateType(TemplateTypeT&& value) {
    m_templateTypeHasBeenSet = true;
    m_templateType = std::forward<TemplateTypeT>(value);
  }
  template <typename TemplateTypeT = Aws::String>
  TemplateVersionResponse& WithTemplateType(TemplateTypeT&& value) {
    SetTemplateType(std::forward<TemplateTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the version of the message template. This value is
   * an integer that Amazon Pinpoint automatically increments and assigns to each new
   * version of a template.</p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  TemplateVersionResponse& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_creationDate;

  Aws::String m_defaultSubstitutions;

  Aws::String m_lastModifiedDate;

  Aws::String m_templateDescription;

  Aws::String m_templateName;

  Aws::String m_templateType;

  Aws::String m_version;
  bool m_creationDateHasBeenSet = false;
  bool m_defaultSubstitutionsHasBeenSet = false;
  bool m_lastModifiedDateHasBeenSet = false;
  bool m_templateDescriptionHasBeenSet = false;
  bool m_templateNameHasBeenSet = false;
  bool m_templateTypeHasBeenSet = false;
  bool m_versionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
