/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.ICommandLineParameterHandler;
import org.jkiss.utils.CommonUtils;

public class InputFileParameterHandler
implements ICommandLineParameterHandler {
    private final Log log = Log.getLog(InputFileParameterHandler.class);
    public static final String INPUT_FILE = "inputFile";

    @Override
    public void handleParameter(@NotNull CommandLine commandLine, @NotNull String name, @Nullable String value, @NotNull CommandLineContext context) {
        if (CommonUtils.isEmpty((String)value)) {
            this.log.warn((Object)"--input-file parameter is empty");
            return;
        }
        Path inputFile = Path.of(value, new String[0]);
        if (Files.notExists(inputFile, new LinkOption[0])) {
            this.log.warn((Object)("--input-file does not exist: " + String.valueOf(inputFile)));
            return;
        }
        context.setContextParameter(INPUT_FILE, inputFile);
    }
}

