/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUIUtils;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolWizardPageSettings;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFileRemote;

class PostgreRestoreWizardPageSettings
extends PostgreToolWizardPageSettings<PostgreRestoreWizard> {
    private TextWithOpenFile inputFileText;
    private Combo formatCombo;
    private Button cleanFirstButton;
    private Button noOwnerCheck;
    private Button createDatabase;

    PostgreRestoreWizardPageSettings(PostgreRestoreWizard wizard) {
        super(wizard, PostgreMessages.wizard_restore_page_setting_title_setting);
        this.setTitle(PostgreMessages.wizard_restore_page_setting_title);
        this.setDescription(PostgreMessages.wizard_restore_page_setting_description);
    }

    protected boolean determinePageCompletion() {
        if (((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).getInputFile() == null) {
            this.setErrorMessage("Input file not specified");
            return false;
        }
        return super.determinePageCompletion();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Listener updateListener = event -> this.updateState();
        Composite formatGroup = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.wizard_restore_page_setting_label_setting, (int)2, (int)768);
        this.formatCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_restore_page_setting_label_format, (int)12);
        this.formatCombo.setLayoutData((Object)new GridData(32));
        PostgreBackupRestoreSettings.ExportFormat[] exportFormatArray = PostgreBackupRestoreSettings.ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgreBackupRestoreSettings.ExportFormat format = exportFormatArray[n2];
            this.formatCombo.add(format.getTitle());
            ++n2;
        }
        PostgreDatabaseRestoreSettings settings = (PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings();
        this.formatCombo.select(settings.getFormat().ordinal());
        this.formatCombo.addListener(13, updateListener);
        this.cleanFirstButton = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_restore_page_setting_btn_clean_first, (String)PostgreMessages.wizard_restore_page_setting_btn_clean_first_tip, (boolean)settings.isCleanFirst(), (int)2);
        this.cleanFirstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PostgreRestoreWizardPageSettings.this.cleanFirstButton.getSelection() && !PostgreRestoreWizardPageSettings.this.confirmDropDatabaseAction()) {
                    PostgreRestoreWizardPageSettings.this.cleanFirstButton.setSelection(false);
                }
            }
        });
        this.cleanFirstButton.addListener(13, updateListener);
        this.createDatabase = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_restore_create_database, (String)PostgreMessages.wizard_backup_page_setting_checkbox_restore_create_database_tip, (boolean)settings.isCreateDatabase(), (int)2);
        this.createDatabase.addListener(13, updateListener);
        this.noOwnerCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_owner, (String)PostgreMessages.wizard_backup_page_setting_checkbox_restore_no_owner_tip, (boolean)settings.isNoOwner(), (int)2);
        this.noOwnerCheck.addListener(13, updateListener);
        Composite inputGroup = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.wizard_restore_page_setting_label_input, (int)2, (int)768);
        UIUtils.createControlLabel((Composite)inputGroup, (String)PostgreMessages.wizard_restore_page_setting_label_backup_file);
        this.inputFileText = new TextWithOpenFileRemote(inputGroup, PostgreMessages.wizard_restore_page_setting_label_choose_backup_file, new String[]{"*.backup", "*.sql", "*"}, 4100, true, ((PostgreRestoreWizard)this.getWizard()).getProject());
        this.inputFileText.setLayoutData((Object)new GridData(768));
        this.inputFileText.getTextControl().addListener(24, updateListener);
        this.inputFileText.setText(settings.getInputFile());
        this.createExtraArgsInput(inputGroup);
        Composite extraGroup = UIUtils.createComposite((Composite)composite, (int)2);
        this.createSecurityGroup(extraGroup);
        PostgreUIUtils.addCompatibilityInfoLabelForForks(composite, this.wizard, null);
        this.setControl((Control)composite);
    }

    private boolean confirmDropDatabaseAction() {
        Shell shell = this.getContainer().getShell();
        if (shell == null) {
            return false;
        }
        if (shell.isVisible() || ((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).isCleanFirst()) {
            return UIUtils.confirmAction((Shell)shell, (String)PostgreMessages.wizard_restore_page_setting_confirm_dialog_title, (String)PostgreMessages.wizard_restore_page_setting_confirm_dialog_message, (DBPImage)DBIcon.STATUS_WARNING);
        }
        return false;
    }

    public void saveState() {
        PostgreDatabaseRestoreSettings settings = (PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings();
        settings.setFormat(PostgreBackupRestoreSettings.ExportFormat.values()[this.formatCombo.getSelectionIndex()]);
        settings.setInputFile(this.inputFileText.getText());
        settings.setCleanFirst(this.cleanFirstButton.getSelection());
        settings.setCreateDatabase(this.createDatabase.getSelection());
        settings.setNoOwner(this.noOwnerCheck.getSelection());
    }

    protected void updateState() {
        this.saveState();
        this.inputFileText.setOpenFolder(((PostgreDatabaseRestoreSettings)((PostgreRestoreWizard)this.wizard).getSettings()).getFormat() == PostgreBackupRestoreSettings.ExportFormat.DIRECTORY);
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }
}

