/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import jogamp.nativewindow.NativeWindowFactoryImpl;

public class DefaultGraphicsDevice
implements Cloneable,
AbstractGraphicsDevice {
    private static final String separator = "_";
    private final String type;
    protected final String connection;
    protected final int unitID;
    protected final String uniqueID;
    protected long handle;
    private Object handleOwner;
    protected ToolkitLock toolkitLock;

    public static String getDefaultDisplayConnection() {
        return NativeWindowFactory.getDefaultDisplayConnection();
    }

    public static String getDefaultDisplayConnection(String string) {
        return NativeWindowFactory.getDefaultDisplayConnection(string);
    }

    public DefaultGraphicsDevice(String string, String string2, int n) {
        this(string, string2, n, 0L, NativeWindowFactory.getDefaultToolkitLock(string));
    }

    public DefaultGraphicsDevice(String string, String string2, int n, long l) {
        this(string, string2, n, l, NativeWindowFactory.getDefaultToolkitLock(string));
    }

    public DefaultGraphicsDevice(String string, String string2, int n, long l, ToolkitLock toolkitLock) {
        this.type = string;
        this.connection = string2;
        this.unitID = n;
        this.uniqueID = DefaultGraphicsDevice.getUniqueID(string, string2, n);
        this.handle = l;
        this.handleOwner = null;
        this.toolkitLock = null != toolkitLock ? toolkitLock : NativeWindowFactoryImpl.getNullToolkitLock();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getConnection() {
        return this.connection;
    }

    @Override
    public final int getUnitID() {
        return this.unitID;
    }

    @Override
    public final String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public final long getHandle() {
        return this.handle;
    }

    @Override
    public final void lock() {
        this.toolkitLock.lock();
    }

    @Override
    public final void validateLocked() throws RuntimeException {
        this.toolkitLock.validateLocked();
    }

    @Override
    public final void unlock() {
        this.toolkitLock.unlock();
    }

    @Override
    public boolean open() {
        return false;
    }

    @Override
    public boolean close() {
        this.toolkitLock.dispose();
        if (0L != this.handle) {
            this.handle = 0L;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isHandleOwner() {
        return null != this.handleOwner;
    }

    @Override
    public final void clearHandleOwner() {
        this.handleOwner = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type " + this.getType() + ", connection " + this.getConnection() + ", unitID " + this.getUnitID() + ", handle 0x" + Long.toHexString(this.getHandle()) + ", owner " + this.isHandleOwner() + ", " + this.toolkitLock + ", obj 0x" + Integer.toHexString(this.hashCode()) + "]";
    }

    protected final long setHandle(long l) {
        long l2 = this.handle;
        this.handle = l;
        return l2;
    }

    protected final Object getHandleOwnership() {
        return this.handleOwner;
    }

    protected final Object setHandleOwnership(Object object) {
        Object object2 = this.handleOwner;
        this.handleOwner = object;
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void swapHandleAndOwnership(DefaultGraphicsDevice defaultGraphicsDevice, DefaultGraphicsDevice defaultGraphicsDevice2) {
        defaultGraphicsDevice.lock();
        try {
            defaultGraphicsDevice2.lock();
            try {
                long l = defaultGraphicsDevice.getHandle();
                long l2 = defaultGraphicsDevice2.setHandle(l);
                defaultGraphicsDevice.setHandle(l2);
                Object object = defaultGraphicsDevice.getHandleOwnership();
                Object object2 = defaultGraphicsDevice2.setHandleOwnership(object);
                defaultGraphicsDevice.setHandleOwnership(object2);
            }
            finally {
                defaultGraphicsDevice2.unlock();
            }
        }
        finally {
            defaultGraphicsDevice.unlock();
        }
    }

    protected ToolkitLock setToolkitLock(ToolkitLock toolkitLock) {
        ToolkitLock toolkitLock2 = this.toolkitLock;
        toolkitLock2.lock();
        try {
            this.toolkitLock = null == toolkitLock ? NativeWindowFactoryImpl.getNullToolkitLock() : toolkitLock;
        }
        finally {
            toolkitLock2.unlock();
        }
        return toolkitLock2;
    }

    public final ToolkitLock getToolkitLock() {
        return this.toolkitLock;
    }

    private static String getUniqueID(String string, String string2, int n) {
        return (string + separator + string2 + separator + n).intern();
    }
}

