/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.HelpLocation;

public class ConvertOctAction
extends ConvertConstantAction {
    public ConvertOctAction(DecompilePlugin plugin) {
        super(plugin, "Convert To Octal", 3);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionConvert"));
        this.setPopupMenuData(new MenuData(new String[]{"Octal"}, "Decompile"));
    }

    @Override
    public String getMenuPrefix() {
        return "Octal: ";
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned, Program program) {
        Scalar scalar = new Scalar(size * 8, value);
        if (isSigned) {
            long v = scalar.getSignedValue();
            String valueStr = Long.toString(v, 8);
            if (v < 0L) {
                return "-0" + valueStr.substring(1);
            }
            return "0" + valueStr;
        }
        String valueStr = Long.toOctalString(scalar.getUnsignedValue());
        return "0" + valueStr;
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        Scalar scalar = new Scalar(size * 8, value);
        return Long.toOctalString(scalar.getUnsignedValue()) + "o";
    }
}

