/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import mdemangler.MDMang;

public class MDMangParseInfo
extends MDMang {
    private Stack<MDParseInfo> infoStack;
    private List<MDParseInfo> infoList;
    private int parseInfoMangledIndex;
    private StringBuilder parseInfoBuilder;
    private static final String TAB0 = "       ";
    private static final String TAB1A = "|  ";
    private static final String TAB1B = "|";
    private static final String TAB2 = "+--";
    private static final String EOL = "\n";

    @Override
    public void resetState() {
        super.resetState();
        this.infoStack = new Stack();
        this.infoList = new ArrayList<MDParseInfo>();
        this.parseInfoMangledIndex = 0;
        this.parseInfoBuilder = new StringBuilder();
    }

    @Override
    public void parseInfoPushPop(int startIndexOffset, String itemName) {
        this.parseInfoPush(startIndexOffset, itemName);
        this.parseInfoPop();
    }

    @Override
    public void parseInfoPush(int startIndexOffset, String itemName) {
        MDParseInfo info = new MDParseInfo(this, this.iter.getIndex() - startIndexOffset, this.infoStack.size(), itemName);
        this.infoStack.push(info);
        this.infoList.add(info);
        this.parseInfoMangledIndex = this.doParseInfoSingle(this.parseInfoBuilder, this.parseInfoMangledIndex, this.infoList.size() - 1);
    }

    @Override
    public void parseInfoPop() {
        int index = Integer.max(this.iter.getIndex() - 1, this.infoList.get(this.infoList.size() - 1).getStartIndex());
        MDParseInfo oldInfo = this.infoStack.pop();
        MDParseInfo info = new MDParseInfo(this, index, this.infoStack.size(), oldInfo.getItemName() + " -- END");
        this.infoList.add(info);
        this.parseInfoMangledIndex = this.doParseInfoSingle(this.parseInfoBuilder, this.parseInfoMangledIndex, this.infoList.size() - 1);
    }

    public String getParseInfoIncremental() {
        return this.parseInfoBuilder.toString();
    }

    private void outputMangledCharAndInfo(StringBuilder builder, int index, int depth, String itemName) {
        if (index >= 0) {
            if (index < this.mangled.length()) {
                builder.append(String.format("%04d %c ", index, Character.valueOf(this.mangled.charAt(index))));
            } else {
                builder.append(String.format("%04d   ", index));
            }
        } else {
            builder.append(TAB0);
        }
        if (itemName == null) {
            while (depth-- > 0) {
                builder.append(TAB1A);
            }
            builder.append(TAB1B);
        } else {
            while (depth-- > 0) {
                builder.append(TAB2);
            }
            builder.append(itemName);
        }
        builder.append(EOL);
    }

    public String getParseInfo_orig() {
        StringBuilder builder = new StringBuilder();
        int mangledIndex = 0;
        int infoIndex = 0;
        while (infoIndex < this.infoList.size()) {
            if (mangledIndex == this.infoList.get((int)infoIndex).startIndex) {
                this.outputMangledCharAndInfo(builder, mangledIndex, this.infoList.get((int)infoIndex).itemDepth, this.infoList.get((int)infoIndex).itemName);
                while (++infoIndex < this.infoList.size() && mangledIndex == this.infoList.get((int)infoIndex).startIndex) {
                    this.outputMangledCharAndInfo(builder, -1, this.infoList.get((int)infoIndex).itemDepth, this.infoList.get((int)infoIndex).itemName);
                }
                continue;
            }
            if (mangledIndex >= this.mangled.length() || mangledIndex == this.infoList.get((int)infoIndex).startIndex) {
                Msg.warn((Object)this, (Object)"Problem with Parse Info Stack");
                break;
            }
            while (mangledIndex < this.infoList.get((int)infoIndex).startIndex) {
                if (infoIndex == 0 || infoIndex != 0 && mangledIndex > this.infoList.get((int)(infoIndex - 1)).startIndex) {
                    this.outputMangledCharAndInfo(builder, mangledIndex, this.infoList.get((int)infoIndex).itemDepth, null);
                }
                ++mangledIndex;
            }
        }
        return builder.toString();
    }

    public String getParseInfo() {
        StringBuilder builder = new StringBuilder();
        int parseInfoMangledIndexLocal = 0;
        int infoIndex = 0;
        while (infoIndex < this.infoList.size()) {
            parseInfoMangledIndexLocal = this.doParseInfoSingle(builder, parseInfoMangledIndexLocal, infoIndex++);
        }
        return builder.toString();
    }

    public int doParseInfoSingle(StringBuilder builder, int parseInfoMangledIndexArg, int infoIndex) {
        while (parseInfoMangledIndexArg < this.infoList.get((int)infoIndex).startIndex) {
            if (infoIndex == 0 || infoIndex != 0 && parseInfoMangledIndexArg > this.infoList.get((int)(infoIndex - 1)).startIndex) {
                this.outputMangledCharAndInfo(builder, parseInfoMangledIndexArg, this.infoList.get((int)infoIndex).itemDepth, null);
            }
            ++parseInfoMangledIndexArg;
        }
        if (parseInfoMangledIndexArg >= this.infoList.get((int)infoIndex).startIndex) {
            if (infoIndex == 0 || this.infoList.get((int)infoIndex).startIndex != this.infoList.get((int)(infoIndex - 1)).startIndex) {
                this.outputMangledCharAndInfo(builder, this.infoList.get((int)infoIndex).startIndex, this.infoList.get((int)infoIndex).itemDepth, this.infoList.get((int)infoIndex).itemName);
            } else {
                this.outputMangledCharAndInfo(builder, -1, this.infoList.get((int)infoIndex).itemDepth, this.infoList.get((int)infoIndex).itemName);
            }
        }
        return parseInfoMangledIndexArg;
    }

    private class MDParseInfo {
        private int startIndex;
        private int itemDepth;
        private String itemName;

        public MDParseInfo(MDMangParseInfo mDMangParseInfo, int startIndex, int itemDepth, String itemName) {
            this.startIndex = startIndex;
            this.itemDepth = itemDepth;
            this.itemName = itemName;
        }

        public String getItemName() {
            return this.itemName;
        }

        public int getStartIndex() {
            return this.startIndex;
        }
    }
}

