/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.export;

import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.EventTrigger;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.export.ExportAttributedGraphDisplayProvider;
import ghidra.graph.export.GraphExporterDialog;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedGraphExporter;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class ExportAttributedGraphDisplay
implements GraphDisplay {
    private final PluginTool tool;
    private String title;
    private AttributedGraph graph;

    ExportAttributedGraphDisplay(ExportAttributedGraphDisplayProvider programGraphDisplayProvider) {
        this.tool = programGraphDisplayProvider.getPluginTool();
    }

    public void close() {
    }

    public void setGraphDisplayListener(GraphDisplayListener listener) {
        listener.dispose();
    }

    private void doSetGraphData(AttributedGraph attributedGraph) {
        List<AttributedGraphExporter> exporters = this.findGraphExporters();
        GraphExporterDialog dialog = (GraphExporterDialog)((Object)Swing.runNow(() -> new GraphExporterDialog(attributedGraph, exporters)));
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private List<AttributedGraphExporter> findGraphExporters() {
        GraphDisplayBroker service = (GraphDisplayBroker)this.tool.getService(GraphDisplayBroker.class);
        if (service != null) {
            return service.getGraphExporters();
        }
        return Collections.emptyList();
    }

    public void setGraph(AttributedGraph graph, String title, boolean append, TaskMonitor monitor) {
        this.title = title;
        this.graph = graph;
        this.doSetGraphData(graph);
    }

    public void setGraph(AttributedGraph graph, GraphDisplayOptions options, String title, boolean append, TaskMonitor monitor) throws CancelledException {
        this.setGraph(graph, title, append, monitor);
    }

    public void clear() {
    }

    public void updateVertexName(AttributedVertex vertex, String newName) {
    }

    public String getGraphTitle() {
        return this.title;
    }

    public void addAction(DockingActionIf action) {
    }

    public Collection<DockingActionIf> getActions() {
        return Collections.emptyList();
    }

    public AttributedVertex getFocusedVertex() {
        return null;
    }

    public Set<AttributedVertex> getSelectedVertices() {
        return Collections.emptySet();
    }

    public void setFocusedVertex(AttributedVertex vertex, EventTrigger eventTrigger) {
    }

    public AttributedGraph getGraph() {
        return this.graph;
    }

    public void selectVertices(Set<AttributedVertex> vertexList, EventTrigger eventTrigger) {
    }
}

