/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13FileRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class AbstractLinesC13Section
extends C13Section {
    private long offCon;
    private int segCon;
    private int flags;
    private long lenCon;
    private List<C13FileRecord> fileRecords = new ArrayList<C13FileRecord>();

    protected AbstractLinesC13Section(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        super(ignore);
        boolean hasColumn;
        if (reader.numRemaining() < 12) {
            throw new PdbException("Not enough data for header");
        }
        this.offCon = reader.parseUnsignedIntVal();
        this.segCon = reader.parseUnsignedShortVal();
        this.flags = reader.parseUnsignedShortVal();
        this.lenCon = reader.parseUnsignedIntVal();
        boolean bl = hasColumn = (this.flags & 1) != 0;
        while (reader.hasMore()) {
            monitor.checkCancelled();
            C13FileRecord fileRecord = C13FileRecord.parse(reader, hasColumn, monitor);
            if (fileRecord == null) break;
            this.fileRecords.add(fileRecord);
        }
    }

    public long getOffCon() {
        return this.offCon;
    }

    public int getSegCon() {
        return this.segCon;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getLenCon() {
        return this.lenCon;
    }

    public List<C13FileRecord> getFileRecords() {
        return this.fileRecords;
    }

    public String toString() {
        return String.format("%s: offCon = %ld, segCon = %d, flags = 0x%04x, lenCon = %d; num records = %d", this.getClass().getSimpleName(), this.offCon, this.segCon, this.flags, this.lenCon, this.fileRecords.size());
    }

    @Override
    protected void dumpInternal(Writer writer, TaskMonitor monitor) throws IOException, CancelledException {
        writer.write(String.format("offCon: 0x%08x segCon: %d flags: 0x%08x lenCon: 0x%08x\n", this.offCon, this.segCon, this.flags, this.lenCon));
        for (C13FileRecord record : this.fileRecords) {
            monitor.checkCancelled();
            record.dump(writer, this.offCon);
        }
    }
}

