/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.action.builder.ActionBuilder;
import docking.widgets.EventTrigger;
import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.program.DataReferenceGraph;
import ghidra.graph.program.DataReferenceGraphTask;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import ghidra.service.graph.VertexGraphActionContext;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DataReferenceGraphDisplayListener
extends AddressBasedGraphDisplayListener {
    private int stepDepth;

    public DataReferenceGraphDisplayListener(PluginTool tool, GraphDisplay display, Program program, int depth) {
        super(tool, program, display);
        this.stepDepth = depth;
        HelpLocation helpLoc = new HelpLocation("ProgramGraphPlugin", "Add_References");
        display.addAction(((ActionBuilder)new ActionBuilder("Add To/From References", "Data Graph").popupMenuPath(new String[]{"Add Bidirectional References For Selection"})).withContext(VertexGraphActionContext.class).helpLocation(helpLoc).onAction(this::addToGraph).build());
        display.addAction(((ActionBuilder)new ActionBuilder("Add To References", "Data Graph").popupMenuPath(new String[]{"Add References To Selection"})).withContext(VertexGraphActionContext.class).helpLocation(helpLoc).onAction(this::addTosToGraph).build());
        display.addAction(((ActionBuilder)new ActionBuilder("Add From References", "Data Graph").popupMenuPath(new String[]{"Add References From Selection"})).withContext(VertexGraphActionContext.class).helpLocation(helpLoc).onAction(this::addFromsToGraph).build());
    }

    private void addToGraph(VertexGraphActionContext context) {
        this.doAdd(context, DataReferenceGraph.Directions.BOTH_WAYS);
    }

    private void addTosToGraph(VertexGraphActionContext context) {
        this.doAdd(context, DataReferenceGraph.Directions.TO_ONLY);
    }

    private void addFromsToGraph(VertexGraphActionContext context) {
        this.doAdd(context, DataReferenceGraph.Directions.FROM_ONLY);
    }

    private void doAdd(VertexGraphActionContext context, DataReferenceGraph.Directions direction) {
        AddressSet addresses = new AddressSet();
        for (AttributedVertex vertex : context.getSelectedVertices()) {
            addresses.add(this.getAddress(vertex));
        }
        DataReferenceGraphTask task = new DataReferenceGraphTask(this.tool, this.program, addresses, this.graphDisplay, this.stepDepth, direction);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
        this.graphDisplay.selectVertices(context.getSelectedVertices(), EventTrigger.INTERNAL_ONLY);
    }

    public GraphDisplayListener cloneWith(GraphDisplay newDisplay) {
        return new DataReferenceGraphDisplayListener(this.tool, newDisplay, this.program, this.stepDepth);
    }

    protected Set<AttributedVertex> getVertices(AddressSetView selection) {
        if (selection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AttributedVertex> vertices = new HashSet<AttributedVertex>();
        DataReferenceGraph graph = (DataReferenceGraph)this.graphDisplay.getGraph();
        for (AddressRange range : selection) {
            for (Address address : range) {
                AttributedVertex vertex = graph.getVertex(graph.makeName(address));
                if (vertex == null) continue;
                vertices.add(vertex);
            }
        }
        return vertices;
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertexIds) {
        AddressSet addrSet = new AddressSet();
        for (AttributedVertex vertex : vertexIds) {
            Address addr = this.getAddress(vertex.getName());
            if (addr == null) continue;
            addrSet.add(addr);
        }
        return addrSet;
    }

    protected Address getAddress(String vertexIdString) {
        AttributedVertex vertex = this.graphDisplay.getGraph().getVertex(vertexIdString);
        return this.program.getAddressFactory().getAddress(vertex.getAttribute("Address"));
    }

    protected String getVertexId(Address address) {
        DataReferenceGraph graph = (DataReferenceGraph)this.graphDisplay.getGraph();
        return graph.makeName(address);
    }
}

