/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.FamilySymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class ValueSymbol
extends FamilySymbol {
    protected PatternValue patval;

    public ValueSymbol(Location location) {
        super(location);
        this.patval = null;
    }

    public ValueSymbol(Location location, String nm, PatternValue pv) {
        super(location, nm);
        this.patval = pv;
        this.patval.layClaim();
    }

    @Override
    public PatternValue getPatternValue() {
        return this.patval;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.patval;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.value_symbol;
    }

    @Override
    public void dispose() {
        if (this.patval != null) {
            PatternExpression.release(this.patval);
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VALUE_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        this.patval.encode(encoder);
        encoder.closeElement(SlaFormat.ELEM_VALUE_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VALUE_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_VALUE_SYM_HEAD);
    }
}

