/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBRecord;
import db.Field;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.module.FragmentDBAdapter;
import ghidra.program.database.module.ModuleManager;
import ghidra.program.database.module.ParentChildDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Lock;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.util.Iterator;

class FragmentDB
extends DatabaseObject
implements ProgramFragment {
    private DBRecord record;
    private ModuleManager moduleMgr;
    private FragmentDBAdapter fragmentAdapter;
    private ParentChildDBAdapter parentChildAdapter;
    private AddressSet addrSet;
    private Lock lock;

    FragmentDB(ModuleManager moduleMgr, DBObjectCache<FragmentDB> cache, DBRecord record, AddressSet addrSet) {
        super(cache, record.getKey());
        this.moduleMgr = moduleMgr;
        this.record = record;
        this.addrSet = addrSet;
        this.fragmentAdapter = moduleMgr.getFragmentAdapter();
        this.parentChildAdapter = moduleMgr.getParentChildAdapter();
        this.lock = moduleMgr.getLock();
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.fragmentAdapter.getFragmentRecord(this.key);
            if (rec != null) {
                this.record = rec;
                this.addrSet = this.moduleMgr.getFragmentAddressSet(this.key);
                return true;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        return false;
    }

    @Override
    public boolean contains(CodeUnit codeUnit) {
        return this.contains(codeUnit.getMinAddress());
    }

    @Override
    public CodeUnitIterator getCodeUnits() {
        this.checkIsValid();
        return this.moduleMgr.getCodeUnits(this);
    }

    @Override
    public String getComment() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(1);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getName() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(0);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumParents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Field[] keys = this.parentChildAdapter.getParentChildKeys(-this.key, 1);
            int n = keys.length;
            return n;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return 0;
    }

    @Override
    public String[] getParentNames() {
        return this.moduleMgr.getParentNames(-this.key);
    }

    @Override
    public ProgramModule[] getParents() {
        return this.moduleMgr.getParents(-this.key);
    }

    @Override
    public void move(Address min, Address max) throws NotFoundException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.moduleMgr.move(this, min, max);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComment(String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            String oldComments = this.record.getString(1);
            if (oldComments == null || !oldComments.equals(comment)) {
                this.record.setString(1, comment);
                try {
                    this.fragmentAdapter.updateFragmentRecord(this.record);
                    this.moduleMgr.commentsChanged(oldComments, this);
                }
                catch (IOException e) {
                    this.moduleMgr.dbError(e);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DBRecord r = this.fragmentAdapter.getFragmentRecord(name);
            if (r != null) {
                if (this.key != r.getKey()) {
                    throw new DuplicateNameException(name + " already exists");
                }
                return;
            }
            if (this.fragmentAdapter.getFragmentRecord(name) != null) {
                throw new DuplicateNameException(name + " already exists");
            }
            String oldName = this.record.getString(0);
            this.record.setString(0, name);
            this.fragmentAdapter.updateFragmentRecord(this.record);
            this.moduleMgr.nameChanged(oldName, this);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getTreeName() {
        return this.moduleMgr.getTreeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Address start, Address end) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.contains(start, end);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(Address addr) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.contains(addr);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.contains(rangeSet);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasSameAddresses(AddressSetView view) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.hasSameAddresses(view);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressIterator getAddresses(boolean forward) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressIterator addressIterator = this.addrSet.getAddresses(forward);
            return addressIterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressIterator getAddresses(Address start, boolean forward) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressIterator addressIterator = this.addrSet.getAddresses(start, forward);
            return addressIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressRangeIterator addressRangeIterator = this.addrSet.getAddressRanges();
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this.getAddressRanges();
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean atStart) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressRangeIterator addressRangeIterator = this.addrSet.getAddressRanges(atStart);
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getMaxAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.addrSet.getMaxAddress();
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getMinAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.addrSet.getMinAddress();
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public long getNumAddresses() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long l = this.addrSet.getNumAddresses();
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumAddressRanges() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.addrSet.getNumAddressRanges();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet intersect(AddressSetView view) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressSet addressSet = this.addrSet.intersect(view);
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSet intersectRange(Address start, Address end) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressSet addressSet = this.addrSet.intersectRange(start, end);
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(Address start, Address end) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.intersects(start, end);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean intersects(AddressSetView set) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.intersects(set);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            boolean bl = this.addrSet.isEmpty();
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet subtract(AddressSetView set) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressSet addressSet = this.addrSet.subtract(set);
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet union(AddressSetView set) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressSet addressSet = this.addrSet.union(set);
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet xor(AddressSetView set) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressSet addressSet = this.addrSet.xor(set);
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    ModuleManager getModuleManager() {
        return this.moduleMgr;
    }

    void addRange(AddressRange range) {
        this.addrSet.add(range);
    }

    void removeRange(AddressRange range) {
        this.addrSet.delete(range);
    }

    public String toString() {
        String name = this.record.getString(0);
        return name + ": " + this.addrSet.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressRangeIterator addressRangeIterator = this.addrSet.getAddressRanges(start, forward);
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRange getFirstRange() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressRange addressRange = this.addrSet.getFirstRange();
            return addressRange;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRange getLastRange() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressRange addressRange = this.addrSet.getLastRange();
            return addressRange;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            AddressRange addressRange = this.addrSet.getRangeContaining(address);
            return addressRange;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Iterator<AddressRange> iterator(boolean forward) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Iterator<AddressRange> iterator = this.addrSet.iterator(forward);
            return iterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Iterator<AddressRange> iterator = this.addrSet.iterator(start, forward);
            return iterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView set) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.addrSet.findFirstAddressInCommon(set);
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted(this.lock);
    }
}

