/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.util.bytesearch.DittedBitSequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PatternInfoRowObject {
    private PatternType type;
    private DittedBitSequence bitSequence;
    private ContextRegisterFilter cRegFilter;
    private String note;
    private Integer alignment;

    public PatternInfoRowObject(PatternType type, DittedBitSequence bitSequence, ContextRegisterFilter cRegFilter) {
        this.type = type;
        this.bitSequence = bitSequence;
        this.cRegFilter = cRegFilter;
        this.alignment = null;
    }

    public PatternType getPatternType() {
        return this.type;
    }

    public DittedBitSequence getDittedBitSequence() {
        return this.bitSequence;
    }

    public ContextRegisterFilter getContextRegisterFilter() {
        return this.cRegFilter;
    }

    public Integer getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Integer alignment) {
        this.alignment = alignment;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note.trim();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.bitSequence.hashCode();
        hash = 31 * hash + Objects.hashCode(this.cRegFilter);
        hash = 31 * hash + Objects.hashCode(this.alignment);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternInfoRowObject)) {
            return false;
        }
        PatternInfoRowObject otherRow = (PatternInfoRowObject)o;
        if (!otherRow.type.equals((Object)this.type)) {
            return false;
        }
        if (!otherRow.bitSequence.equals((Object)this.bitSequence)) {
            return false;
        }
        if (!Objects.equals(otherRow.cRegFilter, this.cRegFilter)) {
            return false;
        }
        return Objects.equals(this.alignment, otherRow.alignment);
    }

    public static void exportXMLFile(List<PatternInfoRowObject> rows, File xmlFile, Integer postbits, Integer totalbits) throws IOException {
        try (FileWriter fWriter = new FileWriter(xmlFile);
             BufferedWriter bWriter = new BufferedWriter(fWriter);){
            bWriter.write("<patternlist>\n");
            bWriter.write("  <patternpairs totalbits=\"");
            bWriter.write(Integer.toString(totalbits));
            bWriter.write("\" postbits=\"");
            bWriter.write(Integer.toString(postbits));
            bWriter.write("\">\n");
            bWriter.write("    <prepatterns>\n");
            for (PatternInfoRowObject row : rows) {
                if (!row.getPatternType().equals((Object)PatternType.PRE)) continue;
                bWriter.write("        <data>");
                bWriter.write(row.getDittedBitSequence().getHexString());
                bWriter.write("</data>\n");
            }
            bWriter.write("    </prepatterns>\n");
            bWriter.write("    <postpatterns>\n");
            for (PatternInfoRowObject row : rows) {
                if (!row.getPatternType().equals((Object)PatternType.FIRST)) continue;
                bWriter.write("       <data>");
                bWriter.write(row.getDittedBitSequence().getHexString());
                bWriter.write("</data>\n");
            }
            Integer alignment = null;
            ContextRegisterFilter cRegFilter = null;
            for (PatternInfoRowObject patternInfoRowObject : rows) {
                if (!patternInfoRowObject.getPatternType().equals((Object)PatternType.FIRST)) continue;
                alignment = patternInfoRowObject.getAlignment();
                cRegFilter = patternInfoRowObject.getContextRegisterFilter();
                break;
            }
            if (alignment != null) {
                bWriter.write("       <align mark=\"0\" bits=\"");
                bWriter.write(Integer.toString(Integer.numberOfTrailingZeros(alignment)));
                bWriter.write("\"/>\n");
            }
            if (cRegFilter != null) {
                for (Map.Entry entry : cRegFilter.getValueMap().entrySet()) {
                    String name = (String)entry.getKey();
                    String value = ((BigInteger)entry.getValue()).toString();
                    bWriter.write("       <setcontext name=\"");
                    bWriter.write(name);
                    bWriter.write("\" value=\"");
                    bWriter.write(value);
                    bWriter.write("\"/>\n");
                }
            }
            bWriter.write("       <funcstart/>\n");
            bWriter.write("    </postpatterns>\n");
            bWriter.write("  </patternpairs>\n");
            bWriter.write("</patternlist>\n");
        }
    }
}

