/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.xar;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.file.formats.xar.XARConstants;
import ghidra.program.model.listing.Program;
import java.util.Arrays;

public class XARUtil {
    public static final boolean isXAR(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider((Program)program, (boolean)true);
        return XARUtil.isXAR((ByteProvider)provider);
    }

    public static final boolean isXAR(ByteProvider provider) {
        try {
            byte[] bytes = provider.readBytes(0L, (long)XARConstants.MAGIC_BYTES.length);
            return Arrays.equals(bytes, XARConstants.MAGIC_BYTES);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

