/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.SymbolNode;
import java.util.HashMap;
import java.util.Map;

class Symbol {
    Map<Integer, SymbolNode> backrefs = new HashMap<Integer, SymbolNode>();
    String mangled;
    int pos = 0;

    public Symbol(String mangled) {
        this.mangled = mangled;
    }

    public void backrefAdd(int index, SymbolNode value) {
        this.backrefs.put(index, value);
        ++index;
    }

    public String getBackref(int index) {
        SymbolNode backref = this.backrefs.get(index);
        if (backref != null) {
            return backref.toString();
        }
        return "{backref " + index + "}";
    }

    public String parseBackref() {
        if (this.stripPrefix('B')) {
            return this.parseBase62Number();
        }
        return null;
    }

    public String remaining() {
        return this.mangled.substring(this.pos);
    }

    public boolean stripPrefix(char c) {
        if (c == this.nextChar()) {
            this.popChar();
            return true;
        }
        return false;
    }

    public char nextChar() {
        return this.mangled.charAt(this.pos);
    }

    public int nextInt() {
        return this.mangled.charAt(this.pos);
    }

    public char popChar() {
        char c = this.mangled.charAt(this.pos);
        ++this.pos;
        return c;
    }

    public int parseDigits() {
        Object num = "";
        if (this.nextChar() == '0') {
            return 0;
        }
        while (this.nextChar() >= '0' && this.nextChar() <= '9') {
            num = (String)num + this.popChar();
        }
        return Integer.parseInt((String)num);
    }

    public String parseUntil(char c) {
        Object data = "";
        while (this.nextChar() != c) {
            data = (String)data + this.popChar();
        }
        return data;
    }

    public void backChar() {
        --this.pos;
    }

    public String parseString(int n) {
        String s = this.mangled.substring(this.pos, this.pos + n);
        this.pos += n;
        return s;
    }

    public boolean isEmpty() {
        return this.mangled.length() <= this.pos;
    }

    public String parseBase62Number() {
        String numString = this.parseUntil('_');
        this.popChar();
        return numString;
    }
}

