/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.proxy;

import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import java.util.ConcurrentModificationException;

public class FunctionProxy
extends ProxyObj<Function> {
    private Program program;
    private Function function;
    private Address functionAddr;
    private Address locationAddr;

    public FunctionProxy(ListingModel model, Program program, Address locationAddr, Function function) {
        super(model);
        this.program = program;
        this.function = function;
        this.locationAddr = locationAddr;
        this.functionAddr = function.getEntryPoint();
    }

    public Address getLocationAddress() {
        return this.locationAddr;
    }

    public Address getFunctionAddress() {
        return this.functionAddr;
    }

    @Override
    public Function getObject() {
        if (this.function != null) {
            try {
                this.function.getEntryPoint();
                return this.function;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        this.function = null;
        Listing listing = this.program.getListing();
        if (!this.locationAddr.equals((Object)this.functionAddr)) {
            if (listing.getFunctionAt(this.locationAddr) != null) {
                return null;
            }
            CodeUnit cu = listing.getCodeUnitAt(this.locationAddr);
            if (!(cu instanceof Data)) {
                return null;
            }
            Data data = (Data)cu;
            if (!(data.getDataType() instanceof Pointer)) {
                return null;
            }
            Reference ref = data.getPrimaryReference(0);
            if (ref == null || !ref.getToAddress().equals((Object)this.functionAddr)) {
                return null;
            }
        }
        this.function = listing.getFunctionAt(this.functionAddr);
        return this.function;
    }

    @Override
    public boolean contains(Address a) {
        Function f = this.getObject();
        if (f == null) {
            return false;
        }
        return f.getBody().contains(a);
    }
}

