/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.factory;

import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.formats.gfilesystem.factory.GFileSystemFactory;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.regex.Pattern;

public class FileSystemInfoRec {
    private static final Pattern FSTYPE_VALID_REGEX = Pattern.compile("[a-z0-9]+");
    private final String type;
    private final String description;
    private final int priority;
    private final Class<? extends GFileSystem> fsClass;
    private final GFileSystemFactory<?> factory;
    public static final Comparator<FileSystemInfoRec> BY_PRIORITY = (o1, o2) -> Integer.compare(o2.priority, o1.priority);

    public static FileSystemInfoRec fromClass(Class<? extends GFileSystem> fsClazz) {
        FileSystemInfo fsi = fsClazz.getAnnotation(FileSystemInfo.class);
        if (fsi == null) {
            return null;
        }
        String fsType = fsi.type();
        if (!FSTYPE_VALID_REGEX.matcher(fsType).matches()) {
            Msg.error(FileSystemInfoRec.class, (Object)("Bad GFileSystem type specified for " + fsClazz.getName() + ": " + fsType + ", skipping."));
            return null;
        }
        Class<GFileSystemFactory<?>> factoryClass = fsi.factory();
        GFileSystemFactory<?> factory = null;
        try {
            Constructor<GFileSystemFactory<?>> ctor = factoryClass.getConstructor(new Class[0]);
            factory = ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Msg.error(FileSystemInfoRec.class, (Object)("Error when creating GFileSystem factory " + factoryClass.getName()), (Throwable)e);
            return null;
        }
        if (factory instanceof GFileSystemBaseFactory) {
            ((GFileSystemBaseFactory)factory).setFileSystemClass(fsClazz);
        }
        FileSystemInfoRec fsir = new FileSystemInfoRec(fsType, fsi.description(), fsi.priority(), fsClazz, factory);
        return fsir;
    }

    private FileSystemInfoRec(String type, String description, int priority, Class<? extends GFileSystem> fsClass, GFileSystemFactory<?> factory) {
        this.type = type;
        this.description = description;
        this.priority = priority;
        this.fsClass = fsClass;
        this.factory = factory;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public Class<? extends GFileSystem> getFSClass() {
        return this.fsClass;
    }

    public GFileSystemFactory<?> getFactory() {
        return this.factory;
    }
}

