/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.features.bsim.query.protocol.SimilarityNote;
import ghidra.features.bsim.query.protocol.SimilarityResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class ExecutableResultWithDeDuping
implements Comparable<ExecutableResultWithDeDuping> {
    private RowKey id;
    private ExecutableRecord exerecord;
    private int funccount;
    private double sumsignif;

    private ExecutableResultWithDeDuping() {
        this.id = null;
        this.exerecord = null;
        this.funccount = 0;
        this.sumsignif = 0.0;
    }

    public ExecutableResultWithDeDuping(ExecutableRecord rec) {
        this.exerecord = rec;
        this.id = rec.getRowId();
        this.funccount = 0;
        this.sumsignif = 0.0;
    }

    public ExecutableRecord getExecutableRecord() {
        return this.exerecord;
    }

    public void addFunction(double signif) {
        ++this.funccount;
        this.sumsignif += signif;
    }

    public int getFunctionCount() {
        return this.funccount;
    }

    public double getSignificanceSum() {
        return this.sumsignif;
    }

    public boolean equals(Object obj) {
        return this.id.equals(((ExecutableResultWithDeDuping)obj).id);
    }

    @Override
    public int compareTo(ExecutableResultWithDeDuping o) {
        return Double.compare(this.getSignificanceSum(), o.getSignificanceSum());
    }

    public static Collection<ExecutableResultWithDeDuping> generate(Iterator<SimilarityResult> iter, Map<FunctionDescription, Integer> duplicationInfo) {
        TreeSet<ExecutableResultWithDeDuping> res = new TreeSet<ExecutableResultWithDeDuping>();
        ExecutableResultWithDeDuping curres = new ExecutableResultWithDeDuping();
        while (iter.hasNext()) {
            SimilarityResult simres = iter.next();
            TreeSet<ExecutableResultWithDeDuping> exetree = new TreeSet<ExecutableResultWithDeDuping>();
            Iterator<SimilarityNote> noteiter = simres.iterator();
            Integer totalNumDuplicates = duplicationInfo.get(simres.getBase());
            if (totalNumDuplicates == null) {
                totalNumDuplicates = 1000;
            }
            HashMap<ExecutableResultWithDeDuping, Integer> dupesInExecutable = new HashMap<ExecutableResultWithDeDuping, Integer>();
            while (noteiter.hasNext()) {
                SimilarityNote note = noteiter.next();
                curres.exerecord = note.getFunctionDescription().getExecutableRecord();
                curres.id = curres.exerecord.getRowId();
                ExecutableResultWithDeDuping tmpres = exetree.floor(curres);
                if (tmpres == null || !tmpres.id.equals(curres.id)) {
                    tmpres = new ExecutableResultWithDeDuping(curres.exerecord);
                    exetree.add(tmpres);
                    tmpres.sumsignif = note.getSignificance();
                    dupesInExecutable.put(tmpres, 1);
                    continue;
                }
                if (tmpres.sumsignif < note.getSignificance()) {
                    tmpres.sumsignif = note.getSignificance();
                    dupesInExecutable.put(tmpres, 1);
                    continue;
                }
                if (tmpres.sumsignif != note.getSignificance() || (Integer)dupesInExecutable.get(tmpres) >= totalNumDuplicates) continue;
                tmpres.sumsignif += note.getSignificance();
                dupesInExecutable.put(tmpres, (Integer)dupesInExecutable.get(tmpres) + 1);
            }
            for (ExecutableResultWithDeDuping eres : exetree) {
                ExecutableResultWithDeDuping tmpres = res.floor(eres);
                if (tmpres == null || !tmpres.id.equals(eres.id)) {
                    tmpres = new ExecutableResultWithDeDuping(eres.exerecord);
                    res.add(tmpres);
                }
                tmpres.addFunction(eres.sumsignif);
            }
        }
        return res;
    }
}

