/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.timeoverview;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.MultiActionDockingAction;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorComponent;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewColorService;
import ghidra.app.plugin.core.debug.gui.timeoverview.TimeOverviewEventListener;
import ghidra.app.plugin.core.debug.gui.timeoverview.timetype.TimeType;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkManager;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.UNSTABLE, packageName="Debugger", category="Debugger", shortDescription="Time Overview Color Manager", description="Provides various color mappings for the trace snap space.", eventsConsumed={TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class, TraceActivatedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class})
public class TimeOverviewColorPlugin
extends AbstractDebuggerPlugin {
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    private final AutoService.Wiring autoServiceWiring;
    public static final String HELP_TOPIC = "OverviewPlugin";
    private static final String ACTIVE_SERVICES = "ActiveServices";
    private List<TimeOverviewColorService> allServices;
    private Map<TimeOverviewColorService, TimeOverviewColorComponent> activeServices = new LinkedHashMap<TimeOverviewColorService, TimeOverviewColorComponent>();
    private Map<TimeOverviewColorService, OverviewToggleAction> actionMap = new HashMap<TimeOverviewColorService, OverviewToggleAction>();
    private MultiActionDockingAction multiAction;
    private Trace currentTrace;
    private final TimeOverviewEventListener eventListener = new TimeOverviewEventListener(this);
    private Map<Trace, TreeSet<Long>> sets = new WeakHashMap<Trace, TreeSet<Long>>();
    private Map<Long, Set<Pair<TimeType, String>>> types = new HashMap<Long, Set<Pair<TimeType, String>>>();
    private long LMAX = Lifespan.ALL.lmax();

    public TimeOverviewColorPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesConsumed((PluginTool)tool, (Object)((Object)this));
    }

    @Override
    protected void init() {
        super.init();
        this.allServices = ClassSearcher.getInstances(TimeOverviewColorService.class);
        this.createActions();
        for (TimeOverviewColorService service : this.allServices) {
            service.initialize(this.tool);
        }
    }

    public void readConfigState(SaveState saveState) {
        String[] activeServiceNames;
        for (String serviceName : activeServiceNames = saveState.getStrings(ACTIVE_SERVICES, new String[0])) {
            TimeOverviewColorService service = this.getService(serviceName);
            if (service == null) {
                Msg.warn((Object)((Object)this), (Object)("Can't restore TimeOverviewColorService: " + serviceName));
                continue;
            }
            OverviewToggleAction action = this.actionMap.get(service);
            action.setSelected(true);
            SwingUtilities.invokeLater(() -> this.installOverview(service));
        }
    }

    private TimeOverviewColorService getService(String serviceName) {
        for (TimeOverviewColorService service : this.allServices) {
            if (!service.getName().equals(serviceName)) continue;
            return service;
        }
        return null;
    }

    protected void cleanup() {
        ArrayList<TimeOverviewColorService> services = new ArrayList<TimeOverviewColorService>(this.activeServices.keySet());
        for (TimeOverviewColorService service : services) {
            this.uninstallOverview(service);
        }
        this.listingService.removeLocalAction((DockingAction)this.multiAction);
    }

    public void writeConfigState(SaveState saveState) {
        saveState.putStrings(ACTIVE_SERVICES, this.getActiveServiceNames());
    }

    private String[] getActiveServiceNames() {
        List<String> names = this.activeServices.keySet().stream().map(s -> s.getName()).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    private void createActions() {
        for (TimeOverviewColorService overviewColorService : this.allServices) {
            this.actionMap.put(overviewColorService, new OverviewToggleAction(this.getName(), overviewColorService));
        }
        this.multiAction = new MultiActionDockingAction("TimeOverview", this.getName());
        this.multiAction.setActions(new ArrayList<OverviewToggleAction>(this.actionMap.values()));
        this.multiAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/x-office-document-template.png")));
        this.listingService.addLocalAction((DockingAction)this.multiAction);
        this.multiAction.setDescription("Toggles trace overview margin displays.");
        this.multiAction.setHelpLocation(new HelpLocation(HELP_TOPIC, HELP_TOPIC));
    }

    public void installOverview(TimeOverviewColorService overviewColorService) {
        overviewColorService.setTrace(this.currentTrace);
        TimeOverviewColorComponent overview = new TimeOverviewColorComponent(this.tool, overviewColorService);
        this.activeServices.put(overviewColorService, overview);
        this.listingService.addOverviewProvider((OverviewProvider)overview);
        overview.installActions();
        overview.setPlugin(this);
    }

    private void uninstallOverview(TimeOverviewColorService overviewColorService) {
        TimeOverviewColorComponent overviewComponent = this.activeServices.get(overviewColorService);
        overviewComponent.uninstallActions();
        this.listingService.removeOverviewProvider((OverviewProvider)overviewComponent);
        this.activeServices.remove(overviewColorService);
        overviewColorService.setTrace(null);
    }

    protected void traceActivated(Trace trace) {
        if (trace != null && trace != this.currentTrace) {
            if (this.currentTrace != null) {
                this.currentTrace.removeListener((DomainObjectListener)this.eventListener);
            }
            this.currentTrace = trace;
            this.currentTrace.addListener((DomainObjectListener)this.eventListener);
            for (TimeOverviewColorService service : this.activeServices.keySet()) {
                service.setTrace(trace);
            }
            this.updateMap();
        }
    }

    protected void traceDeactivated(Trace trace) {
        if (trace == this.currentTrace) {
            this.currentTrace.removeListener((DomainObjectListener)this.eventListener);
            this.currentTrace = null;
            for (TimeOverviewColorService service : this.activeServices.keySet()) {
                service.setTrace(null);
            }
        }
    }

    public void processEvent(PluginEvent event) {
        TraceClosedPluginEvent ev;
        Trace trace;
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev2 = (TraceActivatedPluginEvent)event;
            DebuggerCoordinates coordinates = ev2.getActiveCoordinates();
            this.traceActivated(coordinates.getTrace());
            this.eventListener.coordinatesActivated(coordinates);
        } else if (event instanceof TraceClosedPluginEvent && (trace = (ev = (TraceClosedPluginEvent)event).getTrace()) == this.currentTrace) {
            this.sets.remove(trace);
            this.traceDeactivated(trace);
        }
    }

    void updateMap() {
        TreeSet<Long> set = new TreeSet<Long>();
        Trace trace = this.traceManager.getCurrentTrace();
        TraceThreadManager threadManager = trace.getThreadManager();
        for (Object thread : threadManager.getAllThreads()) {
            this.addObject(set, thread.getObject());
        }
        TraceModuleManager moduleManager = trace.getModuleManager();
        for (Object module : moduleManager.getAllModules()) {
            this.addObject(set, module.getObject());
        }
        TraceMemoryManager memoryManager = trace.getMemoryManager();
        for (Object region : memoryManager.getAllRegions()) {
            this.addObject(set, region.getObject());
        }
        TraceBreakpointManager breakpointManager = trace.getBreakpointManager();
        for (TraceBreakpointLocation bpt : breakpointManager.getAllBreakpointLocations()) {
            this.addObject(set, bpt.getObject());
        }
        TraceBookmarkManager bookmarkManager = trace.getBookmarkManager();
        for (TraceBookmark mark : bookmarkManager.getAllBookmarks()) {
            Lifespan span = mark.getLifespan();
            set.add((Long)span.min());
            if (span.lmax() != this.LMAX) continue;
            set.add((Long)span.max());
        }
        for (TimeOverviewColorComponent provider : this.activeServices.values()) {
            provider.setLifeSet(set);
        }
    }

    private void addObject(TreeSet<Long> set, TraceObject obj) {
        for (Lifespan span : obj.getLife().spans()) {
            set.add((Long)span.min());
            if (span.lmax() != this.LMAX) continue;
            set.add((Long)span.max());
        }
    }

    void updateMap(long offset, TimeType type, String desc, boolean override) {
        TreeSet<Long> set = this.getLifeSet();
        if (!override && set.contains(offset)) {
            return;
        }
        if (offset == this.LMAX) {
            return;
        }
        set.add(offset);
        this.setLifespanType(offset, type, desc);
        for (TimeOverviewColorComponent provider : this.activeServices.values()) {
            provider.setLifeSet(set);
        }
    }

    TreeSet<Long> getLifeSet() {
        TreeSet<Long> set = this.sets.get(this.currentTrace);
        if (set == null) {
            set = new TreeSet();
            this.sets.put(this.currentTrace, set);
        }
        return set;
    }

    public Set<Pair<TimeType, String>> getTypes(Long offset) {
        Set<Pair<TimeType, String>> set = this.types.get(offset);
        if (set == null) {
            set = new HashSet<Pair<TimeType, String>>();
        }
        return set;
    }

    void setLifespanType(Long offset, TimeType type, String desc) {
        Set<Pair<TimeType, String>> set = this.getTypes(offset);
        set.add((Pair<TimeType, String>)new ImmutablePair((Object)type, (Object)desc));
        this.types.put(offset, set);
    }

    public void gotoSnap(Long offset) {
        if (offset == null) {
            offset = 0L;
        }
        this.traceManager.activateSnap(offset.longValue());
    }

    public void setLifespan(Lifespan span) {
        for (TimeOverviewColorComponent provider : this.activeServices.values()) {
            provider.setLifespan(span);
        }
    }

    private class OverviewToggleAction
    extends ToggleDockingAction {
        private TimeOverviewColorService service;

        public OverviewToggleAction(String owner, TimeOverviewColorService service) {
            super(service.getName(), owner);
            this.service = service;
            this.setMenuBarData(new MenuData(new String[]{"Show " + service.getName()}));
            this.setHelpLocation(service.getHelpLocation());
        }

        public void actionPerformed(ActionContext context) {
            if (this.isSelected()) {
                TimeOverviewColorPlugin.this.installOverview(this.service);
            } else {
                TimeOverviewColorPlugin.this.uninstallOverview(this.service);
            }
        }
    }
}

