/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.program.model.pcode.Encoder;
import java.io.IOException;

public class HandleTpl {
    private ConstTpl space;
    private ConstTpl size;
    private ConstTpl ptrspace;
    private ConstTpl ptroffset;
    private ConstTpl ptrsize;
    private ConstTpl temp_space;
    private ConstTpl temp_offset;

    public ConstTpl getSpace() {
        return this.space;
    }

    public ConstTpl getPtrSpace() {
        return this.ptrspace;
    }

    public ConstTpl getPtrOffset() {
        return this.ptroffset;
    }

    public ConstTpl getPtrSize() {
        return this.ptrsize;
    }

    public ConstTpl getSize() {
        return this.size;
    }

    public ConstTpl getTempSpace() {
        return this.temp_space;
    }

    public ConstTpl getTempOffset() {
        return this.temp_offset;
    }

    public void setSize(ConstTpl sz) {
        this.size = new ConstTpl(sz);
    }

    public void setPtrSize(ConstTpl sz) {
        this.ptrsize = new ConstTpl(sz);
    }

    public void setPtrOffset(long val) {
        this.ptroffset = new ConstTpl(ConstTpl.const_type.real, val);
    }

    public void setTempOffset(long val) {
        this.temp_offset = new ConstTpl(ConstTpl.const_type.real, val);
    }

    public HandleTpl() {
        this.space = new ConstTpl();
        this.size = new ConstTpl();
        this.ptrspace = new ConstTpl();
        this.ptroffset = new ConstTpl();
        this.ptrsize = new ConstTpl();
        this.temp_space = new ConstTpl();
        this.temp_offset = new ConstTpl();
    }

    public HandleTpl(VarnodeTpl vn) {
        this.space = new ConstTpl(vn.getSpace());
        this.size = new ConstTpl(vn.getSize());
        this.ptrspace = new ConstTpl(ConstTpl.const_type.real, 0L);
        this.ptroffset = new ConstTpl(vn.getOffset());
        this.ptrsize = new ConstTpl();
        this.temp_space = new ConstTpl();
        this.temp_offset = new ConstTpl();
    }

    public HandleTpl(ConstTpl spc, ConstTpl sz, VarnodeTpl vn, AddrSpace t_space, long t_offset) {
        this.space = new ConstTpl(spc);
        this.size = new ConstTpl(sz);
        this.ptrspace = new ConstTpl(vn.getSpace());
        this.ptroffset = new ConstTpl(vn.getOffset());
        this.ptrsize = new ConstTpl(vn.getSize());
        this.temp_space = new ConstTpl(t_space);
        this.temp_offset = new ConstTpl(ConstTpl.const_type.real, t_offset);
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        this.space.changeHandleIndex(handmap);
        this.size.changeHandleIndex(handmap);
        this.ptrspace.changeHandleIndex(handmap);
        this.ptroffset.changeHandleIndex(handmap);
        this.ptrsize.changeHandleIndex(handmap);
        this.temp_space.changeHandleIndex(handmap);
        this.temp_offset.changeHandleIndex(handmap);
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_HANDLE_TPL);
        this.space.encode(encoder);
        this.size.encode(encoder);
        this.ptrspace.encode(encoder);
        this.ptroffset.encode(encoder);
        this.ptrsize.encode(encoder);
        this.temp_space.encode(encoder);
        this.temp_offset.encode(encoder);
        encoder.closeElement(SlaFormat.ELEM_HANDLE_TPL);
    }

    public void dispose() {
    }
}

