/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import com.google.gson.JsonObject;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.ISF.AbstractIsfObject;
import ghidra.program.model.data.ISF.IsfComponent;
import ghidra.program.model.data.ISF.IsfDataTypeWriter;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.Structure;
import ghidra.util.task.TaskMonitor;

public class IsfComposite
extends AbstractIsfObject {
    public String kind;
    public Integer size;
    public JsonObject fields;

    public IsfComposite(Composite composite, IsfDataTypeWriter writer, TaskMonitor monitor) {
        super((DataType)composite);
        this.size = composite.isZeroLength() ? 0 : composite.getLength();
        this.kind = composite instanceof Structure ? "struct" : "union";
        DataTypeComponent[] components = composite.getDefinedComponents();
        this.fields = new JsonObject();
        for (DataTypeComponent component : components) {
            if (monitor.isCancelled()) break;
            IsfObject type = writer.getObjectTypeDeclaration(component);
            IsfComponent cobj = this.getComponent(component, type);
            Object key = component.getFieldName();
            if (key == null) {
                key = "field" + component.getOrdinal();
                if (component.getParent() instanceof Structure) {
                    key = (String)key + "_0x" + Integer.toHexString(component.getOffset());
                }
            }
            this.fields.add((String)key, writer.getTree(cobj));
        }
    }

    protected IsfComponent getComponent(DataTypeComponent component, IsfObject type) {
        return new IsfComponent(component, type);
    }
}

