/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.j2k.IdeaDocCommentConverter;
import org.jetbrains.kotlin.nj2k.tree.JKComment;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0007*\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018*\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002J\u0010\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019*\u00020\u0006J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019*\u00020\u0006H\u0002J\f\u0010\u001c\u001a\u00020\u000e*\u00020\u0006H\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019*\u00020\u0006H\u0002J\u0012\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019*\u00020\u0006H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0006H\u0002J\f\u0010!\u001a\u00020 *\u00020\u0006H\u0002J\u0016\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002J4\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180%*\u00020\u00062\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/nj2k/FormattingCollector;", "", "<init>", "()V", "commentCache", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/nj2k/tree/JKComment;", "copyFormattingFrom", "", "element", "Lorg/jetbrains/kotlin/nj2k/tree/JKFormattingOwner;", "psi", "copyLineBreaks", "", "copyLineBreaksBefore", "copyCommentsBefore", "copyCommentsAfter", "copyLineBreaksFrom", "asComment", "indent", "", "Lcom/intellij/psi/PsiComment;", "toComments", "", "Lkotlin/sequences/Sequence;", "commentsAfterWithParent", "commentsBeforeWithParent", "isNonCodeElement", "nonCodeElementsAfter", "nonCodeElementsBefore", "lineBreaksBefore", "", "lineBreaksAfter", "getMaxLineBreaksAmong", "elements", "collectComments", "Lkotlin/Pair;", "takeCommentsBefore", "takeCommentsAfter", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nFormattingCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormattingCollector.kt\norg/jetbrains/kotlin/nj2k/FormattingCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,122:1\n1#2:123\n125#3:124\n123#4:125\n112#4,5:126\n*S KotlinDebug\n*F\n+ 1 FormattingCollector.kt\norg/jetbrains/kotlin/nj2k/FormattingCollector\n*L\n56#1:124\n59#1:125\n59#1:126,5\n*E\n"})
public final class FormattingCollector {
    @NotNull
    private final Map<PsiElement, JKComment> commentCache = new LinkedHashMap();

    public final void copyFormattingFrom(@NotNull JKFormattingOwner element, @Nullable PsiElement psi, boolean copyLineBreaks, boolean copyLineBreaksBefore, boolean copyCommentsBefore, boolean copyCommentsAfter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (psi == null || psi instanceof PsiCompiledElement) {
            return;
        }
        Pair<List<JKComment>, List<JKComment>> pair = this.collectComments(psi, copyCommentsBefore, copyCommentsAfter);
        List commentsBefore = (List)pair.component1();
        List commentsAfter = (List)pair.component2();
        CollectionsKt.addAll((Collection)element.getCommentsBefore(), (Iterable)commentsBefore);
        CollectionsKt.addAll((Collection)element.getCommentsAfter(), (Iterable)commentsAfter);
        if (copyLineBreaks) {
            this.copyLineBreaksFrom(element, psi, copyLineBreaksBefore);
        }
    }

    public final void copyLineBreaksFrom(@NotNull JKFormattingOwner element, @Nullable PsiElement psi, boolean copyLineBreaksBefore) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (psi == null) {
            return;
        }
        if (copyLineBreaksBefore) {
            element.setLineBreaksBefore(this.lineBreaksBefore(psi));
        }
        element.setLineBreaksAfter(this.lineBreaksAfter(psi));
    }

    private final JKComment asComment(PsiElement $this$asComment) {
        JKComment jKComment;
        if (this.commentCache.containsKey($this$asComment)) {
            return (JKComment)MapsKt.getValue(this.commentCache, (Object)$this$asComment);
        }
        PsiElement psiElement = $this$asComment;
        if (psiElement instanceof PsiDocComment) {
            jKComment = new JKComment(IdeaDocCommentConverter.INSTANCE.convertDocComment((PsiDocComment)$this$asComment), null, 2, null);
        } else if (psiElement instanceof PsiComment) {
            String string = ((PsiComment)$this$asComment).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            jKComment = new JKComment(string, this.indent((PsiComment)$this$asComment));
        } else {
            jKComment = null;
        }
        if (jKComment == null) {
            return null;
        }
        JKComment token = jKComment;
        this.commentCache.put($this$asComment, token);
        return token;
    }

    private final String indent(PsiComment $this$indent) {
        String string;
        Object object;
        block10: {
            block9: {
                PsiComment psiComment;
                PsiComment it = psiComment = $this$indent;
                boolean bl = false;
                object = $this$indent.getParent() instanceof PsiCodeBlock ? psiComment : null;
                if (object == null || (object = object.getPrevSibling()) == null) break block9;
                PsiComment $this$safeAs$iv = object;
                boolean $i$f$safeAs = false;
                PsiComment psiComment2 = $this$safeAs$iv;
                if (!(psiComment2 instanceof PsiWhiteSpace)) {
                    psiComment2 = null;
                }
                if ((object = (PsiWhiteSpace)psiComment2) != null) break block10;
            }
            return null;
        }
        PsiComment prevWhitespace = object;
        String text = prevWhitespace.getText();
        if (prevWhitespace.getPrevSibling() instanceof PsiStatement) {
            CharSequence charSequence;
            block8: {
                Intrinsics.checkNotNull((Object)text);
                String $this$trimStart$iv = text;
                boolean $i$f$trimStart = false;
                CharSequence $this$trimStart$iv$iv = $this$trimStart$iv;
                boolean $i$f$trimStart2 = false;
                int n = $this$trimStart$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (StringUtil.isLineBreak((char)it)) continue;
                    charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                    break block8;
                }
                charSequence = "";
            }
            string = ((Object)charSequence).toString();
        } else {
            string = text;
        }
        return string;
    }

    private final List<JKComment> toComments(Sequence<? extends PsiElement> $this$toComments) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.takeWhile($this$toComments, FormattingCollector::toComments$lambda$2), arg_0 -> FormattingCollector.toComments$lambda$3(this, arg_0)));
    }

    @NotNull
    public final Sequence<JKComment> commentsAfterWithParent(@NotNull PsiElement $this$commentsAfterWithParent) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)$this$commentsAfterWithParent, (String)"<this>");
        Sequence innerElements = this.nonCodeElementsAfter($this$commentsAfterWithParent);
        PsiElement psiElement = (PsiElement)SequencesKt.lastOrNull(innerElements);
        if ((psiElement != null ? psiElement.getNextSibling() : null) == null && $this$commentsAfterWithParent instanceof PsiKeyword) {
            PsiElement psiElement2 = ((PsiKeyword)$this$commentsAfterWithParent).getParent();
            Sequence sequence2 = psiElement2 != null ? this.nonCodeElementsAfter(psiElement2) : null;
            if (sequence2 == null) {
                sequence2 = SequencesKt.emptySequence();
            }
            sequence = SequencesKt.plus(innerElements, sequence2);
        } else {
            sequence = innerElements;
        }
        return SequencesKt.mapNotNull(sequence, arg_0 -> FormattingCollector.commentsAfterWithParent$lambda$4(this, arg_0));
    }

    private final Sequence<JKComment> commentsBeforeWithParent(PsiElement $this$commentsBeforeWithParent) {
        Sequence sequence;
        Sequence innerElements = this.nonCodeElementsBefore($this$commentsBeforeWithParent);
        PsiElement psiElement = (PsiElement)SequencesKt.firstOrNull(innerElements);
        if ((psiElement != null ? psiElement.getPrevSibling() : null) == null && $this$commentsBeforeWithParent instanceof PsiKeyword) {
            PsiElement psiElement2 = ((PsiKeyword)$this$commentsBeforeWithParent).getParent();
            Sequence sequence2 = psiElement2 != null ? this.nonCodeElementsBefore(psiElement2) : null;
            if (sequence2 == null) {
                sequence2 = SequencesKt.emptySequence();
            }
            sequence = SequencesKt.plus(innerElements, sequence2);
        } else {
            sequence = innerElements;
        }
        return SequencesKt.mapNotNull(sequence, arg_0 -> FormattingCollector.commentsBeforeWithParent$lambda$5(this, arg_0));
    }

    private final boolean isNonCodeElement(PsiElement $this$isNonCodeElement) {
        return $this$isNonCodeElement instanceof PsiComment || $this$isNonCodeElement instanceof PsiWhiteSpace || $this$isNonCodeElement.textMatches((CharSequence)";") || $this$isNonCodeElement.textMatches((CharSequence)",") || $this$isNonCodeElement.getTextLength() == 0;
    }

    private final Sequence<PsiElement> nonCodeElementsAfter(PsiElement $this$nonCodeElementsAfter) {
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$this$nonCodeElementsAfter.getNextSibling(), FormattingCollector::nonCodeElementsAfter$lambda$6), arg_0 -> FormattingCollector.nonCodeElementsAfter$lambda$7(this, arg_0));
    }

    private final Sequence<PsiElement> nonCodeElementsBefore(PsiElement $this$nonCodeElementsBefore) {
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$this$nonCodeElementsBefore.getPrevSibling(), FormattingCollector::nonCodeElementsBefore$lambda$8), arg_0 -> FormattingCollector.nonCodeElementsBefore$lambda$9(this, arg_0));
    }

    private final int lineBreaksBefore(PsiElement $this$lineBreaksBefore) {
        return this.getMaxLineBreaksAmong(this.nonCodeElementsBefore($this$lineBreaksBefore));
    }

    private final int lineBreaksAfter(PsiElement $this$lineBreaksAfter) {
        return this.getMaxLineBreaksAmong(this.nonCodeElementsAfter($this$lineBreaksAfter));
    }

    private final int getMaxLineBreaksAmong(Sequence<? extends PsiElement> elements) {
        int n;
        List whitespaces = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(elements, FormattingCollector::getMaxLineBreaksAmong$lambda$10), FormattingCollector::getMaxLineBreaksAmong$lambda$11));
        if (whitespaces.isEmpty()) {
            n = 0;
        } else {
            Iterator iterator2 = ((Iterable)whitespaces).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            String it = (String)iterator2.next();
            boolean bl = false;
            int n2 = StringUtil.getLineBreakCount((CharSequence)it);
            while (iterator2.hasNext()) {
                String it2 = (String)iterator2.next();
                $i$a$-maxOf-FormattingCollector$getMaxLineBreaksAmong$1 = false;
                int n3 = StringUtil.getLineBreakCount((CharSequence)it2);
                if (n2 >= n3) continue;
                n2 = n3;
            }
            n = n2;
        }
        return n;
    }

    private final Pair<List<JKComment>, List<JKComment>> collectComments(PsiElement $this$collectComments, boolean takeCommentsBefore, boolean takeCommentsAfter) {
        List list2;
        PsiElement[] psiElementArray = $this$collectComments.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        List leftInnerTokens = CollectionsKt.asReversed(this.toComments((Sequence<? extends PsiElement>)ArraysKt.asSequence((Object[])psiElementArray)));
        PsiElement[] psiElementArray2 = $this$collectComments.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
        if (((Object[])psiElementArray2).length == 0) {
            list2 = CollectionsKt.emptyList();
        } else {
            PsiElement[] psiElementArray3 = $this$collectComments.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getChildren(...)");
            list2 = CollectionsKt.asReversed(this.toComments((Sequence<? extends PsiElement>)SequencesKt.generateSequence((Object)ArraysKt.last((Object[])psiElementArray3), FormattingCollector::collectComments$lambda$13)));
        }
        List rightInnerTokens = list2;
        List leftComments = CollectionsKt.asReversed((List)CollectionsKt.plus((Collection)leftInnerTokens, (Sequence)(takeCommentsBefore ? this.commentsBeforeWithParent($this$collectComments) : SequencesKt.emptySequence())));
        List rightComments = CollectionsKt.plus((Collection)rightInnerTokens, (Sequence)(takeCommentsAfter ? this.commentsAfterWithParent($this$collectComments) : SequencesKt.emptySequence()));
        return TuplesKt.to((Object)leftComments, (Object)rightComments);
    }

    private static final boolean toComments$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiComment || it instanceof PsiWhiteSpace || Intrinsics.areEqual((Object)it.getText(), (Object)";");
    }

    private static final JKComment toComments$lambda$3(FormattingCollector this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.asComment(it);
    }

    private static final JKComment commentsAfterWithParent$lambda$4(FormattingCollector this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.asComment(it);
    }

    private static final JKComment commentsBeforeWithParent$lambda$5(FormattingCollector this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.asComment(it);
    }

    private static final PsiElement nonCodeElementsAfter$lambda$6(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNextSibling();
    }

    private static final boolean nonCodeElementsAfter$lambda$7(FormattingCollector this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isNonCodeElement(it);
    }

    private static final PsiElement nonCodeElementsBefore$lambda$8(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPrevSibling();
    }

    private static final boolean nonCodeElementsBefore$lambda$9(FormattingCollector this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isNonCodeElement(it);
    }

    private static final boolean getMaxLineBreaksAmong$lambda$10(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiWhiteSpace;
    }

    private static final String getMaxLineBreaksAmong$lambda$11(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final PsiElement collectComments$lambda$13(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPrevSibling();
    }
}

