/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class MatchVariableConstraint
extends NamedScriptableDefinition {
    private static final Pattern VALID_CONSTRAINT_NAME = Pattern.compile("[a-z][A-Za-z\\d]*");
    private Map<String, String> additionalConstraints;
    @NotNull
    private String regExp;
    private boolean invertRegExp;
    private boolean withinHierarchy;
    private boolean strictlyWithinHierarchy;
    private boolean wholeWordsOnly;
    private int minCount;
    private int maxCount;
    private boolean greedy;
    private boolean invertReference;
    @NotNull
    private String referenceConstraint;
    @NotNull
    private String referenceConstraintName;
    private boolean partOfSearchResults;
    @NotNull
    private String nameOfExprType;
    @NotNull
    private String expressionTypes;
    private boolean invertExprType;
    private boolean exprTypeWithinHierarchy;
    @NotNull
    private String nameOfFormalArgType;
    @NotNull
    private String expectedTypes;
    private boolean invertFormalType;
    private boolean formalArgTypeWithinHierarchy;
    @NotNull
    private String withinConstraint;
    @NotNull
    private String containsConstraint;
    private boolean invertContainsConstraint;
    private boolean invertWithinConstraint;
    @NotNull
    private String contextConstraint;
    @NonNls
    private static final String REFERENCE_CONDITION = "reference";
    @NonNls
    private static final String NAME_OF_EXPRTYPE = "nameOfExprType";
    @NonNls
    private static final String NAME_OF_FORMALTYPE = "nameOfFormalType";
    @NonNls
    private static final String REGEXP = "regexp";
    @NonNls
    private static final String EXPRTYPE_WITHIN_HIERARCHY = "exprTypeWithinHierarchy";
    @NonNls
    private static final String FORMALTYPE_WITHIN_HIERARCHY = "formalTypeWithinHierarchy";
    @NonNls
    private static final String WITHIN_HIERARCHY = "withinHierarchy";
    @NonNls
    private static final String MAX_OCCURS = "maxCount";
    @NonNls
    private static final String MIN_OCCURS = "minCount";
    @NonNls
    private static final String NEGATE_NAME_CONDITION = "negateName";
    @NonNls
    private static final String NEGATE_EXPRTYPE_CONDITION = "negateExprType";
    @NonNls
    private static final String NEGATE_FORMALTYPE_CONDITION = "negateFormalType";
    @NonNls
    private static final String NEGATE_CONTAINS_CONDITION = "negateContains";
    @NonNls
    private static final String NEGATE_WITHIN_CONDITION = "negateWithin";
    @NonNls
    private static final String NEGATE_REFERENCE_CONDITION = "negateReference";
    @NonNls
    private static final String WITHIN_CONDITION = "within";
    @NonNls
    private static final String CONTAINS_CONDITION = "contains";
    @NonNls
    private static final String TARGET = "target";
    @NonNls
    private static final String CONTEXT = "context";
    @NonNls
    private static final String WHOLE_WORDS_ONLY = "wholeWordsOnly";
    @NonNls
    private static final String TRUE = Boolean.TRUE.toString();

    public MatchVariableConstraint() {
        this.regExp = "";
        this.minCount = 1;
        this.maxCount = 1;
        this.greedy = true;
        this.referenceConstraint = "";
        this.referenceConstraintName = "";
        this.nameOfExprType = "";
        this.expressionTypes = "";
        this.nameOfFormalArgType = "";
        this.expectedTypes = "";
        this.withinConstraint = "";
        this.containsConstraint = "";
        this.contextConstraint = "";
    }

    public MatchVariableConstraint(@NotNull String name) {
        if (name == null) {
            MatchVariableConstraint.$$$reportNull$$$0(0);
        }
        this.regExp = "";
        this.minCount = 1;
        this.maxCount = 1;
        this.greedy = true;
        this.referenceConstraint = "";
        this.referenceConstraintName = "";
        this.nameOfExprType = "";
        this.expressionTypes = "";
        this.nameOfFormalArgType = "";
        this.expectedTypes = "";
        this.withinConstraint = "";
        this.containsConstraint = "";
        this.contextConstraint = "";
        this.setName(name);
    }

    private MatchVariableConstraint(@NotNull MatchVariableConstraint constraint) {
        if (constraint == null) {
            MatchVariableConstraint.$$$reportNull$$$0(1);
        }
        super(constraint);
        this.regExp = "";
        this.minCount = 1;
        this.maxCount = 1;
        this.greedy = true;
        this.referenceConstraint = "";
        this.referenceConstraintName = "";
        this.nameOfExprType = "";
        this.expressionTypes = "";
        this.nameOfFormalArgType = "";
        this.expectedTypes = "";
        this.withinConstraint = "";
        this.containsConstraint = "";
        this.contextConstraint = "";
        this.regExp = constraint.regExp;
        this.invertRegExp = constraint.invertRegExp;
        this.withinHierarchy = constraint.withinHierarchy;
        this.strictlyWithinHierarchy = constraint.strictlyWithinHierarchy;
        this.wholeWordsOnly = constraint.wholeWordsOnly;
        this.minCount = constraint.minCount;
        this.maxCount = constraint.maxCount;
        this.greedy = constraint.greedy;
        this.invertReference = constraint.invertReference;
        this.referenceConstraint = constraint.referenceConstraint;
        this.referenceConstraintName = constraint.referenceConstraintName;
        this.partOfSearchResults = constraint.partOfSearchResults;
        this.nameOfExprType = constraint.nameOfExprType;
        this.expressionTypes = constraint.expressionTypes;
        this.invertExprType = constraint.invertExprType;
        this.exprTypeWithinHierarchy = constraint.exprTypeWithinHierarchy;
        this.nameOfFormalArgType = constraint.nameOfFormalArgType;
        this.expectedTypes = constraint.expectedTypes;
        this.invertFormalType = constraint.invertFormalType;
        this.formalArgTypeWithinHierarchy = constraint.formalArgTypeWithinHierarchy;
        this.withinConstraint = constraint.withinConstraint;
        this.containsConstraint = constraint.containsConstraint;
        this.invertContainsConstraint = constraint.invertContainsConstraint;
        this.invertWithinConstraint = constraint.invertWithinConstraint;
        this.contextConstraint = constraint.contextConstraint;
        Map<String, String> additionalConstraints = constraint.additionalConstraints;
        if (additionalConstraints != null) {
            for (Map.Entry<String, String> entry : additionalConstraints.entrySet()) {
                this.putAdditionalConstraint(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public MatchVariableConstraint copy() {
        return new MatchVariableConstraint(this);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static String convertRegExpTypeToTypeString(@NotNull String regexp) {
        if (regexp == null) {
            MatchVariableConstraint.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        int length = regexp.length();
        for (int i = 0; i < length; ++i) {
            int c = regexp.codePointAt(i);
            if (c == 46) {
                if (i == length - 1 || !MatchUtil.isRegExpMetaChar(regexp.codePointAt(i + 1))) {
                    result.append('.');
                    continue;
                }
                return "";
            }
            if (c == 124) {
                result.append('|');
                continue;
            }
            if (c == 92) {
                if (i + 1 < length) {
                    int d = regexp.codePointAt(i + 1);
                    if (!MatchUtil.isRegExpMetaChar(d)) {
                        return "";
                    }
                    result.appendCodePoint(d);
                    ++i;
                    continue;
                }
                result.append('\\');
                continue;
            }
            if (c == 93) {
                result.append(']');
                continue;
            }
            if (c == 40 || c == 41) continue;
            if (MatchUtil.isRegExpMetaChar(c)) {
                return "";
            }
            result.appendCodePoint(c);
        }
        String string = result.toString();
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(3);
        }
        return string;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static String convertTypeStringToRegExp(@NotNull String typeString) {
        if (typeString == null) {
            MatchVariableConstraint.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder();
        for (String type : StringUtil.split((String)typeString, (String)"|")) {
            if (!result.isEmpty()) {
                result.append('|');
            }
            MatchUtil.shieldRegExpMetaChars(type.trim(), result);
        }
        String string = result.toString();
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    @NotNull
    public String getRegExp() {
        String string = this.regExp;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setRegExp(@NotNull String regExp) {
        if (regExp == null) {
            MatchVariableConstraint.$$$reportNull$$$0(7);
        }
        this.regExp = regExp;
    }

    public boolean isInvertRegExp() {
        return this.invertRegExp;
    }

    public void setInvertRegExp(boolean invertRegExp) {
        this.invertRegExp = invertRegExp;
    }

    public boolean isWithinHierarchy() {
        return this.withinHierarchy;
    }

    public void setWithinHierarchy(boolean withinHierarchy) {
        this.withinHierarchy = withinHierarchy;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public boolean isPartOfSearchResults() {
        return this.partOfSearchResults;
    }

    public void setPartOfSearchResults(boolean partOfSearchResults) {
        this.partOfSearchResults = partOfSearchResults;
    }

    public boolean isInvertReference() {
        return this.invertReference;
    }

    public void setInvertReference(boolean invertReference) {
        this.invertReference = invertReference;
    }

    @NotNull
    public String getReferenceConstraint() {
        String string = this.referenceConstraint;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setReferenceConstraint(@NotNull String nameOfReferenceVar) {
        if (nameOfReferenceVar == null) {
            MatchVariableConstraint.$$$reportNull$$$0(9);
        }
        this.referenceConstraint = nameOfReferenceVar;
    }

    @NotNull
    public String getReferenceConstraintName() {
        String string = this.referenceConstraintName;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setReferenceConstraintName(@NotNull String referenceConstraintName) {
        if (referenceConstraintName == null) {
            MatchVariableConstraint.$$$reportNull$$$0(11);
        }
        this.referenceConstraintName = referenceConstraintName;
    }

    public boolean isStrictlyWithinHierarchy() {
        return this.strictlyWithinHierarchy;
    }

    public void setStrictlyWithinHierarchy(boolean strictlyWithinHierarchy) {
        this.strictlyWithinHierarchy = strictlyWithinHierarchy;
    }

    @NotNull
    public String getNameOfExprType() {
        String string = this.nameOfExprType;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getExpressionTypes() {
        String string = this.expressionTypes;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void setNameOfExprType(@NotNull String nameOfExprType) {
        if (nameOfExprType == null) {
            MatchVariableConstraint.$$$reportNull$$$0(14);
        }
        this.nameOfExprType = nameOfExprType;
        this.expressionTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(nameOfExprType);
    }

    public void setExpressionTypes(@NotNull String expressionTypes) {
        if (expressionTypes == null) {
            MatchVariableConstraint.$$$reportNull$$$0(15);
        }
        this.expressionTypes = expressionTypes;
        this.nameOfExprType = MatchVariableConstraint.convertTypeStringToRegExp(expressionTypes);
    }

    public boolean isRegexExprType() {
        return StringUtil.isEmpty((String)this.expressionTypes) && !StringUtil.isEmpty((String)this.nameOfExprType);
    }

    public boolean isInvertExprType() {
        return this.invertExprType;
    }

    public void setInvertExprType(boolean invertExprType) {
        this.invertExprType = invertExprType;
    }

    public boolean isExprTypeWithinHierarchy() {
        return this.exprTypeWithinHierarchy;
    }

    public void setExprTypeWithinHierarchy(boolean exprTypeWithinHierarchy) {
        this.exprTypeWithinHierarchy = exprTypeWithinHierarchy;
    }

    public boolean isWholeWordsOnly() {
        return this.wholeWordsOnly;
    }

    public void setWholeWordsOnly(boolean wholeWordsOnly) {
        this.wholeWordsOnly = wholeWordsOnly;
    }

    @NotNull
    public String getNameOfFormalArgType() {
        String string = this.nameOfFormalArgType;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getExpectedTypes() {
        String string = this.expectedTypes;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(17);
        }
        return string;
    }

    public void setNameOfFormalArgType(@NotNull String nameOfFormalArgType) {
        if (nameOfFormalArgType == null) {
            MatchVariableConstraint.$$$reportNull$$$0(18);
        }
        this.nameOfFormalArgType = nameOfFormalArgType;
        this.expectedTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(nameOfFormalArgType);
    }

    public void setExpectedTypes(@NotNull String expectedTypes) {
        if (expectedTypes == null) {
            MatchVariableConstraint.$$$reportNull$$$0(19);
        }
        this.expectedTypes = expectedTypes;
        this.nameOfFormalArgType = MatchVariableConstraint.convertTypeStringToRegExp(expectedTypes);
    }

    public boolean isRegexFormalType() {
        return StringUtil.isEmpty((String)this.expectedTypes) && !StringUtil.isEmpty((String)this.nameOfFormalArgType);
    }

    public boolean isInvertFormalType() {
        return this.invertFormalType;
    }

    public void setInvertFormalType(boolean invertFormalType) {
        this.invertFormalType = invertFormalType;
    }

    public boolean isFormalArgTypeWithinHierarchy() {
        return this.formalArgTypeWithinHierarchy;
    }

    public void setFormalArgTypeWithinHierarchy(boolean formalArgTypeWithinHierarchy) {
        this.formalArgTypeWithinHierarchy = formalArgTypeWithinHierarchy;
    }

    @NotNull
    public String getContextConstraint() {
        String string = this.contextConstraint;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(20);
        }
        return string;
    }

    public void setContextConstraint(@NotNull String contextConstraint) {
        if (contextConstraint == null) {
            MatchVariableConstraint.$$$reportNull$$$0(21);
        }
        this.contextConstraint = contextConstraint;
    }

    private static boolean isValidConstraintName(String name) {
        return VALID_CONSTRAINT_NAME.matcher(name).matches();
    }

    public void putAdditionalConstraint(String name, String value) {
        if (!MatchVariableConstraint.isValidConstraintName(name)) {
            throw new IllegalArgumentException("Invalid constraint name");
        }
        if (this.additionalConstraints == null) {
            if (value == null) {
                return;
            }
            this.additionalConstraints = new HashMap<String, String>();
        }
        if (value == null) {
            this.additionalConstraints.remove(name);
            if (this.additionalConstraints.isEmpty()) {
                this.additionalConstraints = null;
            }
        } else {
            this.additionalConstraints.put(name, value);
        }
    }

    public String getAdditionalConstraint(String name) {
        return this.additionalConstraints == null ? null : this.additionalConstraints.get(name);
    }

    public Map<String, String> getAllAdditionalConstraints() {
        return this.additionalConstraints == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.additionalConstraints);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchVariableConstraint)) {
            return false;
        }
        MatchVariableConstraint other = (MatchVariableConstraint)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.exprTypeWithinHierarchy != other.exprTypeWithinHierarchy) {
            return false;
        }
        if (this.formalArgTypeWithinHierarchy != other.formalArgTypeWithinHierarchy) {
            return false;
        }
        if (this.greedy != other.greedy) {
            return false;
        }
        if (this.invertExprType != other.invertExprType) {
            return false;
        }
        if (this.invertFormalType != other.invertFormalType) {
            return false;
        }
        if (this.invertReference != other.invertReference) {
            return false;
        }
        if (this.invertRegExp != other.invertRegExp) {
            return false;
        }
        if (this.maxCount != other.maxCount) {
            return false;
        }
        if (this.minCount != other.minCount) {
            return false;
        }
        if (this.partOfSearchResults != other.partOfSearchResults) {
            return false;
        }
        if (this.strictlyWithinHierarchy != other.strictlyWithinHierarchy) {
            return false;
        }
        if (this.wholeWordsOnly != other.wholeWordsOnly) {
            return false;
        }
        if (this.withinHierarchy != other.withinHierarchy) {
            return false;
        }
        if (!this.nameOfExprType.equals(other.nameOfExprType)) {
            return false;
        }
        if (!this.expressionTypes.equals(other.expressionTypes)) {
            return false;
        }
        if (!this.nameOfFormalArgType.equals(other.nameOfFormalArgType)) {
            return false;
        }
        if (!this.expectedTypes.equals(other.expectedTypes)) {
            return false;
        }
        if (!this.referenceConstraint.equals(other.referenceConstraint)) {
            return false;
        }
        if (!this.regExp.equals(other.regExp)) {
            return false;
        }
        if (!this.withinConstraint.equals(other.withinConstraint)) {
            return false;
        }
        if (!this.containsConstraint.equals(other.containsConstraint)) {
            return false;
        }
        if (this.invertWithinConstraint != other.invertWithinConstraint) {
            return false;
        }
        if (this.invertContainsConstraint != other.invertContainsConstraint) {
            return false;
        }
        if (!this.contextConstraint.equals(other.contextConstraint)) {
            return false;
        }
        if (this.additionalConstraints != null) {
            return this.additionalConstraints.equals(other.additionalConstraints);
        }
        return other.additionalConstraints == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.regExp.hashCode();
        result = 29 * result + (this.invertRegExp ? 1 : 0);
        result = 29 * result + (this.withinHierarchy ? 1 : 0);
        result = 29 * result + (this.strictlyWithinHierarchy ? 1 : 0);
        result = 29 * result + (this.wholeWordsOnly ? 1 : 0);
        result = 29 * result + this.minCount;
        result = 29 * result + this.maxCount;
        result = 29 * result + (this.greedy ? 1 : 0);
        result = 29 * result + (this.invertReference ? 1 : 0);
        result = 29 * result + this.referenceConstraint.hashCode();
        result = 29 * result + (this.partOfSearchResults ? 1 : 0);
        result = 29 * result + this.nameOfExprType.hashCode();
        result = 29 * result + this.expressionTypes.hashCode();
        result = 29 * result + (this.invertExprType ? 1 : 0);
        result = 29 * result + (this.exprTypeWithinHierarchy ? 1 : 0);
        result = 29 * result + this.nameOfFormalArgType.hashCode();
        result = 29 * result + this.expectedTypes.hashCode();
        result = 29 * result + (this.invertFormalType ? 1 : 0);
        result = 29 * result + (this.formalArgTypeWithinHierarchy ? 1 : 0);
        result = 29 * result + this.withinConstraint.hashCode();
        result = 29 * result + this.containsConstraint.hashCode();
        result = 29 * result + this.contextConstraint.hashCode();
        if (this.invertContainsConstraint) {
            result = 29 * result + 1;
        }
        if (this.invertWithinConstraint) {
            result = 29 * result + 1;
        }
        if (this.additionalConstraints != null) {
            result = 29 * result + this.additionalConstraints.hashCode();
        }
        return result;
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.regExp = StringUtil.notNullize((String)element.getAttributeValue(REGEXP));
        this.withinHierarchy = MatchVariableConstraint.getBooleanValue(element, WITHIN_HIERARCHY, false);
        this.invertRegExp = MatchVariableConstraint.getBooleanValue(element, NEGATE_NAME_CONDITION, false);
        this.wholeWordsOnly = MatchVariableConstraint.getBooleanValue(element, WHOLE_WORDS_ONLY, false);
        this.nameOfExprType = StringUtil.notNullize((String)element.getAttributeValue(NAME_OF_EXPRTYPE));
        this.expressionTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(this.nameOfExprType);
        this.exprTypeWithinHierarchy = MatchVariableConstraint.getBooleanValue(element, EXPRTYPE_WITHIN_HIERARCHY, false);
        this.invertExprType = MatchVariableConstraint.getBooleanValue(element, NEGATE_EXPRTYPE_CONDITION, false);
        this.nameOfFormalArgType = StringUtil.notNullize((String)element.getAttributeValue(NAME_OF_FORMALTYPE));
        this.expectedTypes = MatchVariableConstraint.convertRegExpTypeToTypeString(this.nameOfFormalArgType);
        this.formalArgTypeWithinHierarchy = MatchVariableConstraint.getBooleanValue(element, FORMALTYPE_WITHIN_HIERARCHY, false);
        this.invertFormalType = MatchVariableConstraint.getBooleanValue(element, NEGATE_FORMALTYPE_CONDITION, false);
        this.minCount = MatchVariableConstraint.getIntValue(element, MIN_OCCURS, 1);
        this.maxCount = MatchVariableConstraint.getIntValue(element, MAX_OCCURS, 1);
        this.referenceConstraint = StringUtil.notNullize((String)element.getAttributeValue(REFERENCE_CONDITION));
        this.invertReference = MatchVariableConstraint.getBooleanValue(element, NEGATE_REFERENCE_CONDITION, false);
        this.containsConstraint = StringUtil.notNullize((String)element.getAttributeValue(CONTAINS_CONDITION));
        this.invertContainsConstraint = MatchVariableConstraint.getBooleanValue(element, NEGATE_CONTAINS_CONDITION, false);
        this.withinConstraint = StringUtil.notNullize((String)element.getAttributeValue(WITHIN_CONDITION));
        this.invertWithinConstraint = MatchVariableConstraint.getBooleanValue(element, NEGATE_WITHIN_CONDITION, false);
        this.partOfSearchResults = MatchVariableConstraint.getBooleanValue(element, TARGET, false);
        this.contextConstraint = StringUtil.notNullize((String)element.getAttributeValue(CONTEXT));
        for (Attribute attribute : element.getAttributes()) {
            String mangledName = attribute.getName();
            if (!StringUtil.startsWith((CharSequence)mangledName, (CharSequence)"_")) continue;
            String name = mangledName.substring(1);
            if (!MatchVariableConstraint.isValidConstraintName(name)) {
                throw new InvalidDataException();
            }
            if (this.additionalConstraints == null) {
                this.additionalConstraints = new HashMap<String, String>();
            }
            this.additionalConstraints.put(name, attribute.getValue());
        }
    }

    public static boolean getBooleanValue(Element element, String attributeName, boolean defaultValue) {
        Attribute attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            try {
                return attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntValue(Element element, String attributeName, int defaultValue) {
        Attribute attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            try {
                return attribute.getIntValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (!this.regExp.isEmpty()) {
            element.setAttribute(REGEXP, this.regExp);
        }
        if (!this.nameOfExprType.isEmpty()) {
            element.setAttribute(NAME_OF_EXPRTYPE, this.nameOfExprType);
        }
        if (!this.referenceConstraint.isEmpty()) {
            element.setAttribute(REFERENCE_CONDITION, this.referenceConstraint);
        }
        if (!this.nameOfFormalArgType.isEmpty()) {
            element.setAttribute(NAME_OF_FORMALTYPE, this.nameOfFormalArgType);
        }
        if (this.withinHierarchy) {
            element.setAttribute(WITHIN_HIERARCHY, TRUE);
        }
        if (this.exprTypeWithinHierarchy) {
            element.setAttribute(EXPRTYPE_WITHIN_HIERARCHY, TRUE);
        }
        if (this.formalArgTypeWithinHierarchy) {
            element.setAttribute(FORMALTYPE_WITHIN_HIERARCHY, TRUE);
        }
        if (this.minCount != 1) {
            element.setAttribute(MIN_OCCURS, String.valueOf(this.minCount));
        }
        if (this.maxCount != 1) {
            element.setAttribute(MAX_OCCURS, String.valueOf(this.maxCount));
        }
        if (this.partOfSearchResults) {
            element.setAttribute(TARGET, TRUE);
        }
        if (this.invertRegExp) {
            element.setAttribute(NEGATE_NAME_CONDITION, TRUE);
        }
        if (this.invertExprType) {
            element.setAttribute(NEGATE_EXPRTYPE_CONDITION, TRUE);
        }
        if (this.invertFormalType) {
            element.setAttribute(NEGATE_FORMALTYPE_CONDITION, TRUE);
        }
        if (this.invertReference) {
            element.setAttribute(NEGATE_REFERENCE_CONDITION, TRUE);
        }
        if (this.wholeWordsOnly) {
            element.setAttribute(WHOLE_WORDS_ONLY, TRUE);
        }
        if (this.invertContainsConstraint) {
            element.setAttribute(NEGATE_CONTAINS_CONDITION, TRUE);
        }
        if (this.invertWithinConstraint) {
            element.setAttribute(NEGATE_WITHIN_CONDITION, TRUE);
        }
        element.setAttribute(WITHIN_CONDITION, this.withinConstraint);
        element.setAttribute(CONTAINS_CONDITION, this.containsConstraint);
        if (!this.contextConstraint.isEmpty()) {
            element.setAttribute(CONTEXT, this.contextConstraint);
        }
        if (this.additionalConstraints != null && !this.additionalConstraints.isEmpty()) {
            List list = ContainerUtil.sorted(this.additionalConstraints.keySet());
            for (String key : list) {
                String value = this.additionalConstraints.get(key);
                if (value == null) continue;
                element.setAttribute("_" + key, value);
            }
        }
    }

    @NotNull
    public String getWithinConstraint() {
        String string = this.withinConstraint;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(22);
        }
        return string;
    }

    public void setWithinConstraint(@NotNull String withinConstraint) {
        if (withinConstraint == null) {
            MatchVariableConstraint.$$$reportNull$$$0(23);
        }
        this.withinConstraint = withinConstraint;
    }

    @NotNull
    public String getContainsConstraint() {
        String string = this.containsConstraint;
        if (string == null) {
            MatchVariableConstraint.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void setContainsConstraint(@NotNull String containsConstraint) {
        if (containsConstraint == null) {
            MatchVariableConstraint.$$$reportNull$$$0(25);
        }
        this.containsConstraint = containsConstraint;
    }

    public boolean isInvertContainsConstraint() {
        return this.invertContainsConstraint;
    }

    public void setInvertContainsConstraint(boolean invertContainsConstraint) {
        this.invertContainsConstraint = invertContainsConstraint;
    }

    public boolean isInvertWithinConstraint() {
        return this.invertWithinConstraint;
    }

    public void setInvertWithinConstraint(boolean invertWithinConstraint) {
        this.invertWithinConstraint = invertWithinConstraint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 10, 12, 13, 16, 17, 20, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGEXP;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/MatchVariableConstraint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regExp";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOfReferenceVar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceConstraintName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_OF_EXPRTYPE;
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOfFormalArgType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConstraint";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withinConstraint";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containsConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/MatchVariableConstraint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRegExpTypeToTypeString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTypeStringToRegExp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegExp";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceConstraint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceConstraintName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameOfExprType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameOfFormalArgType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextConstraint";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithinConstraint";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainsConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertRegExpTypeToTypeString";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertTypeStringToRegExp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRegExp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setReferenceConstraint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setReferenceConstraintName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNameOfExprType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionTypes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNameOfFormalArgType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setExpectedTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setContextConstraint";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setWithinConstraint";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setContainsConstraint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 10, 12, 13, 16, 17, 20, 22, 24 -> new IllegalStateException(string);
        };
    }
}

