/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.OID4VCEnvironmentProviderFactory;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class OID4VCMapper
implements ProtocolMapper,
OID4VCEnvironmentProviderFactory {
    public static final String CLAIM_NAME = "claim.name";
    public static final String USER_ATTRIBUTE_KEY = "userAttribute";
    private static final List<ProviderConfigProperty> OID4VC_CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    protected ProtocolMapperModel mapperModel;
    protected String format;

    protected abstract List<ProviderConfigProperty> getIndividualConfigProperties();

    public List<ProviderConfigProperty> getConfigProperties() {
        return Stream.concat(OID4VC_CONFIG_PROPERTIES.stream(), this.getIndividualConfigProperties().stream()).toList();
    }

    public OID4VCMapper setMapperModel(ProtocolMapperModel mapperModel, String format) {
        this.mapperModel = mapperModel;
        this.format = format;
        return this;
    }

    public boolean includeInMetadata() {
        return Optional.ofNullable((String)this.mapperModel.getConfig().get("vc.include_in_metadata")).map(Boolean::parseBoolean).orElse(true);
    }

    public List<String> getMetadataAttributePath() {
        String claimName = (String)this.mapperModel.getConfig().get(CLAIM_NAME);
        String userAttributeName = (String)this.mapperModel.getConfig().get(USER_ATTRIBUTE_KEY);
        return ListUtils.union(this.getAttributePrefix(), List.of(Optional.ofNullable(claimName).orElse(userAttributeName)));
    }

    protected List<String> getAttributePrefix() {
        return switch (Optional.ofNullable(this.format).orElse("")) {
            case "jwt_vc", "ldp_vc" -> List.of("credentialSubject");
            default -> Collections.emptyList();
        };
    }

    public String getProtocol() {
        return "oid4vc";
    }

    public String getDisplayCategory() {
        return "OID4VC Mapper";
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
    }

    public void close() {
    }

    public abstract void setClaimsForCredential(VerifiableCredential var1, UserSessionModel var2);

    public abstract void setClaimsForSubject(Map<String, Object> var1, UserSessionModel var2);
}

