/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;

public final class CompletableFutures {
    public static final CompletableFuture[] EMPTY_ARRAY = new CompletableFuture[0];
    private static final CompletableFuture<Boolean> completedTrueFuture = CompletableFuture.completedFuture(Boolean.TRUE);
    private static final CompletableFuture<Boolean> completedFalseFuture = CompletableFuture.completedFuture(Boolean.FALSE);
    private static final CompletableFuture<?> completedEmptyMapFuture = CompletableFuture.completedFuture(Collections.emptyMap());
    private static final CompletableFuture<?> completedNullFuture = CompletableFuture.completedFuture(null);
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);
    private static final Function<?, ?> TO_NULL = o -> null;
    private static final Function<?, Boolean> TO_TRUE_FUNCTION = o -> Boolean.TRUE;
    private static final Function<?, ?> identity = t -> t;

    private CompletableFutures() {
    }

    public static <K, V> CompletableFuture<Map<K, V>> completedEmptyMap() {
        return completedEmptyMapFuture;
    }

    public static <T> CompletableFuture<T> completedNull() {
        return completedNullFuture;
    }

    public static CompletableFuture<Boolean> completedTrue() {
        return completedTrueFuture;
    }

    public static CompletableFuture<Boolean> completedFalse() {
        return completedFalseFuture;
    }

    public static CompletionStage<Boolean> booleanStage(boolean trueOrFalse) {
        return trueOrFalse ? completedTrueFuture : completedFalseFuture;
    }

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> all = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return all.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static boolean await(CompletableFuture<?> future, long time, TimeUnit unit) throws InterruptedException {
        try {
            Objects.requireNonNull(future, "Completable Future must be non-null.").get(time, Objects.requireNonNull(unit, "Time Unit must be non-null"));
            return true;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public static boolean uncheckedAwait(CompletableFuture<?> future, long time, TimeUnit unit) {
        try {
            Objects.requireNonNull(future, "Completable Future must be non-null.").get(time, Objects.requireNonNull(unit, "Time Unit must be non-null"));
            return true;
        }
        catch (ExecutionException e) {
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(e);
        }
    }

    public static <T> T await(CompletableFuture<T> future) throws ExecutionException, InterruptedException {
        try {
            return Objects.requireNonNull(future, "Completable Future must be non-null.").get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
    }

    public static <T> T uncheckedAwait(CompletableFuture<T> future) {
        try {
            return Objects.requireNonNull(future, "Completable Future must be non-null.").get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(e);
        }
        catch (ExecutionException e) {
            throw new CacheException(e);
        }
    }

    public static CompletionException asCompletionException(Throwable t) {
        if (t instanceof CompletionException) {
            return (CompletionException)t;
        }
        return new CompletionException(t);
    }

    public static void rethrowExceptionIfPresent(Throwable t) {
        if (t != null) {
            throw CompletableFutures.asCompletionException(t);
        }
    }

    public static Throwable extractException(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable cause = t.getCause();
        if (cause != null && t instanceof CompletionException) {
            return cause;
        }
        return t;
    }

    public static <T, R> Function<T, R> toNullFunction() {
        return TO_NULL;
    }

    public static <T> Function<T, Boolean> toTrueFunction() {
        return TO_TRUE_FUNCTION;
    }

    public static <T> Function<T, T> identity() {
        return identity;
    }
}

