/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.criteria.Nulls;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.query.SortDirection;

public class NullPrecedenceHelper {
    public static boolean isDefaultOrdering(Nulls precedence, SortDirection sortOrder, NullOrdering nullOrdering) {
        return switch (precedence) {
            default -> throw new IncompatibleClassChangeError();
            case Nulls.NONE -> true;
            case Nulls.FIRST -> {
                switch (nullOrdering) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case FIRST: {
                        yield true;
                    }
                    case LAST: {
                        yield false;
                    }
                    case SMALLEST: {
                        if (sortOrder == SortDirection.ASCENDING) {
                            yield true;
                        }
                        yield false;
                    }
                    case GREATEST: 
                }
                if (sortOrder == SortDirection.DESCENDING) {
                    yield true;
                }
                yield false;
            }
            case Nulls.LAST -> {
                switch (nullOrdering) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LAST: {
                        yield true;
                    }
                    case FIRST: {
                        yield false;
                    }
                    case SMALLEST: {
                        if (sortOrder == SortDirection.DESCENDING) {
                            yield true;
                        }
                        yield false;
                    }
                    case GREATEST: 
                }
                yield sortOrder == SortDirection.ASCENDING;
            }
        };
    }

    public static Nulls parse(String name) {
        for (Nulls value : Nulls.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static Nulls parse(String name, Nulls defaultValue) {
        Nulls value = NullPrecedenceHelper.parse(name);
        return value != null ? value : defaultValue;
    }

    private NullPrecedenceHelper() {
    }
}

