/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.List;
import java.util.function.Function;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ReadOnlyException;

public class ReadOnlyUserModelDelegate
extends UserModelDelegate {
    private final Function<String, RuntimeException> exceptionCreator;
    private Boolean enabled;

    public ReadOnlyUserModelDelegate(UserModel delegate) {
        this(delegate, ReadOnlyException::new);
    }

    public ReadOnlyUserModelDelegate(UserModel delegate, boolean enabled) {
        this(delegate, ReadOnlyException::new);
        this.enabled = enabled;
    }

    public ReadOnlyUserModelDelegate(UserModel delegate, Function<String, RuntimeException> exceptionCreator) {
        super(delegate);
        this.exceptionCreator = exceptionCreator;
    }

    public ReadOnlyUserModelDelegate(UserModel delegate, boolean enabled, Function<String, RuntimeException> exceptionCreator) {
        this(delegate, exceptionCreator);
        this.enabled = enabled;
    }

    public void setUsername(String username) {
        throw this.readOnlyException("username");
    }

    public void setEnabled(boolean enabled) {
        throw this.readOnlyException("enabled");
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            return super.isEnabled();
        }
        return this.enabled;
    }

    public void setSingleAttribute(String name, String value) {
        throw this.readOnlyException("attribute(" + name + ")");
    }

    public void setAttribute(String name, List<String> values) {
        throw this.readOnlyException("attribute(" + name + ")");
    }

    public void removeAttribute(String name) {
        throw this.readOnlyException("attribute(" + name + ")");
    }

    public void addRequiredAction(String action) {
        throw this.readOnlyException("required action " + action);
    }

    public void removeRequiredAction(String action) {
        throw this.readOnlyException("required action " + action);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        throw this.readOnlyException("required action " + String.valueOf(action));
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        throw this.readOnlyException("required action " + String.valueOf(action));
    }

    public void setFirstName(String firstName) {
        throw this.readOnlyException("firstName");
    }

    public void setLastName(String lastName) {
        throw this.readOnlyException("lastName");
    }

    public void setEmail(String email) {
        throw this.readOnlyException("email");
    }

    public void setEmailVerified(boolean verified) {
        throw this.readOnlyException("emailVerified");
    }

    public void deleteRoleMapping(RoleModel role) {
        throw this.readOnlyException("role mapping for role " + role.getName());
    }

    public void setFederationLink(String link) {
        throw this.readOnlyException("federationLink");
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        throw this.readOnlyException("serviceAccountClientLink");
    }

    public void setCreatedTimestamp(Long timestamp) {
        throw this.readOnlyException("createdTimestamp");
    }

    public void joinGroup(GroupModel group) {
        throw this.readOnlyException("group mapping for group " + group.getName());
    }

    public void leaveGroup(GroupModel group) {
        throw this.readOnlyException("group mapping for group " + group.getName());
    }

    public void grantRole(RoleModel role) {
        throw this.readOnlyException("role mapping for role " + role.getName());
    }

    private RuntimeException readOnlyException(String detail) {
        String message = String.format("The user is read-only. Not possible to write '%s' when updating user '%s'.", detail, this.getUsername());
        return this.exceptionCreator.apply(message);
    }
}

