/* 
 *     Copyright (c) 2017, 2021, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

#define __gnu_linux__ 1

#if defined(__cplusplus) &&  __cplusplus >= 201103L
  #define __GXX_EXPERIMENTAL_CXX0X__ 1
#endif

#define __GCC_ATOMIC_TEST_AND_SET_TRUEVAL 1

#define __GCC_ATOMIC_BOOL_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR_LOCK_FREE 2
#define __GCC_ATOMIC_WCHAR_T_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR8_T_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR16_T_LOCK_FREE 2
#define __GCC_ATOMIC_CHAR32_T_LOCK_FREE 2
#define __GCC_ATOMIC_SHORT_LOCK_FREE 2
#define __GCC_ATOMIC_INT_LOCK_FREE 2
#define __GCC_ATOMIC_LONG_LOCK_FREE 2
#define __GCC_ATOMIC_LLONG_LOCK_FREE 2
#define __GCC_ATOMIC_POINTER_LOCK_FREE 2

#ifndef __USER_LABEL_PREFIX__
  #define __USER_LABEL_PREFIX__
#endif

#if __pgnu_vsn >=60000
  #define _GLIBCXX_TXN_SAFE
  #define _GLIBCXX_TXN_SAFE_DYN
#endif

#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1
#define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1

#define __ORDER_BIG_ENDIAN__    4321
#define __ORDER_LITTLE_ENDIAN__ 1234
#define __ORDER_PDP_ENDIAN__    3412
#define __BYTE_ORDER__          __ORDER_LITTLE_ENDIAN__
#define __FLOAT_WORD_ORDER__    __ORDER_LITTLE_ENDIAN__

#ifdef _WIN64
#define _NO_CRT_STDIO_INLINE
#define WINEDG 1
#endif

#if defined(__NVCC_HOST__) && __CUDACC_VER_MAJOR__ < 13
  /* CUDA Toolkit headers define __ELF__ as empty rather than as 1.  Avoid
     warnings about an incompatible redefinition. */
  #undef __ELF__
  #define __ELF__
#endif
