/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;

public class DescribeProducersResult {
    private final Map<TopicPartition, KafkaFuture<PartitionProducerState>> futures;

    DescribeProducersResult(Map<TopicPartition, KafkaFuture<PartitionProducerState>> futures) {
        this.futures = futures;
    }

    public KafkaFuture<PartitionProducerState> partitionResult(TopicPartition partition) {
        KafkaFuture<PartitionProducerState> future = this.futures.get(partition);
        if (future == null) {
            throw new IllegalArgumentException("Topic partition " + String.valueOf(partition) + " was not included in the request");
        }
        return future;
    }

    public KafkaFuture<Map<TopicPartition, PartitionProducerState>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap<TopicPartition, PartitionProducerState> results = new HashMap<TopicPartition, PartitionProducerState>(this.futures.size());
            for (Map.Entry<TopicPartition, KafkaFuture<PartitionProducerState>> entry : this.futures.entrySet()) {
                try {
                    results.put(entry.getKey(), entry.getValue().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new KafkaException(e);
                }
            }
            return results;
        });
    }

    public static class PartitionProducerState {
        private final List<ProducerState> activeProducers;

        public PartitionProducerState(List<ProducerState> activeProducers) {
            this.activeProducers = activeProducers;
        }

        public List<ProducerState> activeProducers() {
            return this.activeProducers;
        }

        public String toString() {
            return "PartitionProducerState(activeProducers=" + String.valueOf(this.activeProducers) + ")";
        }
    }
}

