/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;

public class NewLineMatchFilter
implements RuleMatchFilter {
    private static final String INVISIBLE_SEPARATOR = "\u2063";

    @Override
    public List<RuleMatch> filter(List<RuleMatch> ruleMatches, AnnotatedText text) {
        return ruleMatches.stream().filter((? super T ruleMatch) -> {
            int from = ruleMatch.getFromPos();
            int to = ruleMatch.getToPos();
            if (text.getOriginalText().length() < from || text.getOriginalText().length() < to) {
                return true;
            }
            String matchText = text.getOriginalText().substring(from, to);
            while (matchText.endsWith("\n") || matchText.endsWith(INVISIBLE_SEPARATOR)) {
                matchText = matchText.substring(0, matchText.length() - 1);
                if (--to >= from) continue;
                return false;
            }
            while (matchText.startsWith("\n") || matchText.startsWith(INVISIBLE_SEPARATOR)) {
                matchText = matchText.substring(1);
                ++from;
            }
            ArrayList<String> newSuggestionReplacements = new ArrayList<String>();
            ruleMatch.getSuggestedReplacements().forEach(replacement -> {
                String newReplacement = replacement;
                while (newReplacement.endsWith("\n") || newReplacement.endsWith(INVISIBLE_SEPARATOR)) {
                    newReplacement = newReplacement.substring(0, newReplacement.length() - 1);
                }
                while (newReplacement.startsWith("\n") || newReplacement.startsWith(INVISIBLE_SEPARATOR)) {
                    newReplacement = newReplacement.substring(1);
                }
                newSuggestionReplacements.add(newReplacement);
            });
            if (newSuggestionReplacements.size() == 1 && ((String)newSuggestionReplacements.get(0)).equals(matchText)) {
                return false;
            }
            ruleMatch.setOffsetPosition(from, to);
            ruleMatch.setSuggestedReplacements(newSuggestionReplacements);
            return true;
        }).collect(Collectors.toCollection(ArrayList::new));
    }
}

