/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class GitBranchPresentation {
    public static final int BRANCH_NAME_LENGTH_DELTA = 4;
    public static final int BRANCH_NAME_SUFFIX_LENGTH = 5;
    private static final int DEFAULT_MAX_BRANCH_NAME_LENGTH = 80;

    @NlsSafe
    @NotNull
    public static String truncateBranchName(@NotNull Project project, @NotNull @NlsSafe String branchName) {
        if (project == null) {
            GitBranchPresentation.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            GitBranchPresentation.$$$reportNull$$$0(1);
        }
        return GitBranchPresentation.truncateBranchName(project, branchName, 80);
    }

    @NlsSafe
    @NotNull
    public static String truncateBranchName(@NotNull Project project, @NotNull @NlsSafe String branchName, int maxBranchNameLength) {
        if (project == null) {
            GitBranchPresentation.$$$reportNull$$$0(2);
        }
        if (branchName == null) {
            GitBranchPresentation.$$$reportNull$$$0(3);
        }
        return GitBranchPresentation.truncateBranchName(project, branchName, maxBranchNameLength, 5, 4);
    }

    @NlsSafe
    @NotNull
    public static String truncateBranchName(@NotNull Project project, @NotNull @NlsSafe String branchName, int maxBranchNameLength, int suffixLength, int delta) {
        int branchNameLength;
        if (project == null) {
            GitBranchPresentation.$$$reportNull$$$0(4);
        }
        if (branchName == null) {
            GitBranchPresentation.$$$reportNull$$$0(5);
        }
        if ((branchNameLength = branchName.length()) <= maxBranchNameLength + delta) {
            String string = branchName;
            if (string == null) {
                GitBranchPresentation.$$$reportNull$$$0(6);
            }
            return string;
        }
        IssueNavigationConfiguration issueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
        List issueMatches = issueNavigationConfiguration.findIssueLinks((CharSequence)branchName);
        int affectedMaxBranchNameLength = maxBranchNameLength - "\u2026".length();
        if (!issueMatches.isEmpty()) {
            IssueNavigationConfiguration.LinkMatch firstMatch = (IssueNavigationConfiguration.LinkMatch)issueMatches.get(0);
            TextRange firstMatchRange = firstMatch.getRange();
            return GitBranchPresentation.truncateAndSaveIssueId(firstMatchRange, branchName, affectedMaxBranchNameLength, suffixLength, delta);
        }
        if (affectedMaxBranchNameLength - suffixLength - "\u2026".length() < 0) {
            String string = branchName;
            if (string == null) {
                GitBranchPresentation.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)branchName, (int)affectedMaxBranchNameLength, (int)suffixLength, (boolean)true);
        if (string == null) {
            GitBranchPresentation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String truncateAndSaveIssueId(@NotNull TextRange issueIdRange, @NotNull String branchName, int maxBranchNameLength, int suffixLength, int delta) {
        Object prefixAndIssue;
        int startOffset;
        int endOffset;
        int branchNameLength;
        String issueId;
        block12: {
            String string;
            String truncatedByDefault;
            if (issueIdRange == null) {
                GitBranchPresentation.$$$reportNull$$$0(9);
            }
            if (branchName == null) {
                GitBranchPresentation.$$$reportNull$$$0(10);
            }
            if ((truncatedByDefault = StringUtil.shortenTextWithEllipsis((String)branchName, (int)maxBranchNameLength, (int)suffixLength, (boolean)true)).contains(issueId = issueIdRange.substring(branchName))) {
                String string2 = truncatedByDefault;
                if (string2 == null) {
                    GitBranchPresentation.$$$reportNull$$$0(11);
                }
                return string2;
            }
            try {
                branchNameLength = branchName.length();
                endOffset = issueIdRange.getEndOffset();
                startOffset = issueIdRange.getStartOffset();
                if (endOffset < branchNameLength - suffixLength - delta) break block12;
                string = StringUtil.shortenTextWithEllipsis((String)branchName, (int)maxBranchNameLength, (int)(branchNameLength - startOffset), (boolean)true);
            }
            catch (Throwable e) {
                String string3 = truncatedByDefault;
                if (string3 == null) {
                    GitBranchPresentation.$$$reportNull$$$0(14);
                }
                return string3;
            }
            if (string == null) {
                GitBranchPresentation.$$$reportNull$$$0(12);
            }
            return string;
        }
        String suffix = branchName.substring(branchNameLength - suffixLength);
        int prefixLength = maxBranchNameLength - suffixLength - issueId.length();
        if (Math.abs(startOffset - prefixLength) <= delta) {
            prefixAndIssue = branchName.substring(0, endOffset);
        } else {
            String prefix = branchName.substring(0, prefixLength);
            prefixAndIssue = prefix + "\u2026" + issueId;
        }
        String string = (String)prefixAndIssue + "\u2026" + suffix;
        if (string == null) {
            GitBranchPresentation.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/git/ui/GitBranchPresentation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueIdRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/git/ui/GitBranchPresentation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateBranchName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateAndSaveIssueId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "truncateBranchName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "truncateAndSaveIssueId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

