/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.HttpConnection;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLConnection;

public class HttpBufferedOutputStream
extends BufferedOutputStream {
    private HttpConnection http;
    private ByteArrayOutputStream os;
    private String session = null;

    public HttpBufferedOutputStream(ByteArrayOutputStream os, HttpConnection http, String id) throws IOException {
        super(os);
        this.os = os;
        this.session = id;
        this.http = http;
    }

    @Override
    public final void write(int i) throws IOException {
        this.os.write(i);
    }

    @Override
    public final void write(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
    }

    @Override
    public final void flush() throws IOException {
        int proxyVer = this.http.getProxyVersion();
        if (proxyVer < 210 && this.os.size() > 0 || proxyVer >= 210 && this.os.size() > 1000000) {
            URLConnection conn = this.http.openConnection(false, true, true);
            this.http.setRequestProperty("JDBC_SESSION", this.session);
            this.http.setRequestProperty("JDBC_REQUEST", "SEND");
            this.http.flush(conn);
            String status = this.http.getHeaderField("JDBC_REQUEST");
            String session = this.http.getHeaderField("JDBC_SESSION");
            if (status.equals("SEND_ERR")) {
                throw new IOException(session);
            }
        }
        this.os = this.http.getOutputStream();
    }

    @Override
    public final void close() throws IOException {
        this.http.stopKeepAlive();
        URLConnection conn = this.http.openConnection(false, true, true);
        this.http.setRequestProperty("JDBC_SESSION", this.session);
        this.http.setRequestProperty("JDBC_REQUEST", "CLOSE");
        this.http.flush(conn);
    }

    public final void sendOOBData() throws IOException {
        URLConnection conn = this.http.openConnection(false, true, true);
        this.http.setRequestProperty("JDBC_SESSION", this.session);
        this.http.setRequestProperty("JDBC_REQUEST", "OOBDATA");
        this.http.flush(conn);
        this.session = this.http.getHeaderField("JDBC_SESSION");
    }
}

