/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;

public class IfxFloat
extends IfxObject {
    private double value;

    IfxFloat() throws SQLException {
        this.setIfxType(3);
    }

    IfxFloat(double d) {
        this.setIfxType(3);
        this.value = d;
        this.unnullify();
    }

    IfxFloat(Double D) {
        this.setIfxType(3);
        if (D != null) {
            this.value = D;
            this.unnullify();
        }
    }

    IfxFloat(float f) {
        this.setIfxType(3);
        this.value = f;
        this.unnullify();
    }

    IfxFloat(Float F) {
        this.setIfxType(3);
        if (F != null) {
            this.value = F.floatValue();
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[8];
            Arrays.fill(b, (byte)-1);
            return b;
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        boolean null_flg = true;
        null_flg = IfxFloat.isIfxNull(b, offset, length);
        if (!null_flg) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaDouble(b, offset);
        } else {
            this.nullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxFloat) {
            IfxFloat floatOther = (IfxFloat)other;
            if (floatOther.isNull()) {
                return false;
            }
            return this.value == floatOther.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        byte b = this.isNull() ? (byte)0 : (byte)this.value;
        return b;
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        this.value = b;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.value = B.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double D) throws SQLException {
        if (D == null) {
            this.nullify();
        } else {
            this.value = D;
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short S) throws SQLException {
        if (S == null) {
            this.nullify();
        } else {
            this.value = S.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        this.clearWarning();
        int i = this.isNull() ? 0 : (int)this.value;
        return i;
    }

    @Override
    public void fromInt(int i) throws SQLException {
        this.value = i;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.value = I.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        return l;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    @Override
    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.nullify();
        } else {
            this.value = L.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        this.clearWarning();
        float f = this.isNull() ? 0.0f : (float)this.value;
        return f;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float F) throws SQLException {
        if (F == null) {
            this.nullify();
        } else {
            this.value = F.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigdec) throws SQLException {
        if (bigdec == null) {
            this.nullify();
        } else {
            this.value = bigdec.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean b = this.isNull() ? false : this.value != 0.0;
        return b;
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        this.value = b ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.value = b == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Double.toString(this.value);
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            try {
                this.value = Double.parseDouble(str.trim());
                this.unnullify();
            }
            catch (Exception e) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    static boolean isIfxNull(double d) {
        byte[] b = JavaToIfxType.JavaToIfxDouble(d);
        return IfxFloat.isIfxNull(b);
    }

    static boolean isIfxNull(byte[] b) {
        return IfxFloat.isIfxNull(b, 0, b.length);
    }

    static boolean isIfxNull(byte[] b, int offset, int length) {
        for (int i = 0; i < 8; ++i) {
            if (b[i + offset] == -1) continue;
            return false;
        }
        return true;
    }

    static double getIfxNull() {
        byte[] b = new byte[8];
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            b[i] = -1;
            d = IfxToJavaType.IfxToJavaDouble(b);
        }
        return d;
    }
}

